/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

public class MibLoader {
    private ArrayList dirs = new ArrayList();
    private ArrayList resources = new ArrayList();
    private ArrayList mibs = new ArrayList();
    private ArrayList queue = new ArrayList();
    private DefaultContext context = new DefaultContext();

    public MibLoader() {
        this.addResourceDir("mibs/iana");
        this.addResourceDir("mibs/ietf");
    }

    public void addDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        if (!this.dirs.contains(dir)) {
            this.dirs.add(dir);
        }
    }

    public void addDirs(File[] dirs) {
        int i = 0;
        while (i < dirs.length) {
            this.addDir(dirs[i]);
            ++i;
        }
    }

    public void addAllDirs(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        this.addDir(dir);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.addAllDirs(files[i]);
            }
            ++i;
        }
    }

    public void removeDir(File dir) {
        ((AbstractCollection)this.dirs).remove(dir);
    }

    public void removeAllDirs() {
        this.dirs.clear();
    }

    public void addResourceDir(String dir) {
        if (!this.resources.contains(dir)) {
            this.resources.add(dir);
        }
    }

    public void removeResourceDir(String dir) {
        ((AbstractCollection)this.resources).remove(dir);
    }

    public void removeAllResourceDirs() {
        this.resources.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public Mib getMib(String name) {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(name)) {
                return mib;
            }
            ++i;
        }
        return null;
    }

    public Mib getMib(File file) {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(file)) {
                return mib;
            }
            ++i;
        }
        return null;
    }

    public Mib[] getAllMibs() {
        Mib[] res = new Mib[this.mibs.size()];
        this.mibs.toArray(res);
        return res;
    }

    public Mib load(String name) throws IOException, MibLoaderException {
        Mib mib = this.getMib(name);
        if (mib == null) {
            MibSource src = this.locate(name);
            if (src == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
            }
            mib = this.load(src);
        }
        return mib;
    }

    public Mib load(File file) throws IOException, MibLoaderException {
        Mib mib = this.getMib(file);
        if (mib == null) {
            mib = this.load(new MibSource(file));
        }
        return mib;
    }

    public Mib load(URL url) throws IOException, MibLoaderException {
        return this.load(new MibSource(url));
    }

    public Mib load(Reader input) throws IOException, MibLoaderException {
        return this.load(new MibSource(input));
    }

    private Mib load(MibSource src) throws IOException, MibLoaderException {
        int position = this.mibs.size();
        this.queue.clear();
        this.queue.add(src);
        MibLoaderLog log = this.loadQueue();
        if (log.errorCount() > 0) {
            throw new MibLoaderException(log);
        }
        return (Mib)this.mibs.get(position);
    }

    public void unload(String name) throws MibLoaderException {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(name)) {
                this.unload(mib);
            }
            ++i;
        }
    }

    public void unload(File file) throws MibLoaderException {
        int i = 0;
        while (i < this.mibs.size()) {
            Mib mib = (Mib)this.mibs.get(i);
            if (mib.equals(file)) {
                this.unload(mib);
            }
            ++i;
        }
    }

    public void unload(Mib mib) throws MibLoaderException {
        int pos = this.mibs.indexOf(mib);
        if (pos >= 0) {
            int i = 0;
            while (i < this.mibs.size()) {
                Mib referer = (Mib)this.mibs.get(i);
                if (referer.getImport(mib.getName()) != null) {
                    String message = "cannot be unloaded due to reference in " + referer;
                    throw new MibLoaderException(mib.getFile(), message);
                }
                ++i;
            }
            this.mibs.remove(pos);
        }
    }

    void scheduleLoad(String name) throws IOException {
        if (this.getMib(name) == null) {
            MibSource src = this.locate(name);
            if (src == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
            }
            this.scheduleLoad(src);
        }
    }

    void scheduleLoad(File file) {
        if (this.getMib(file) == null) {
            this.scheduleLoad(new MibSource(file));
        }
    }

    private void scheduleLoad(MibSource src) {
        if (!this.mibs.contains(src.getFile()) && !this.queue.contains(src)) {
            this.queue.add(src);
        }
    }

    private MibLoaderLog loadQueue() throws IOException {
        MibLoaderLog log = new MibLoaderLog();
        ArrayList<Mib> processed = new ArrayList<Mib>();
        while (this.queue.size() > 0) {
            try {
                MibSource src = (MibSource)this.queue.get(0);
                processed.add(src.createMib(this, log));
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
            this.queue.remove(0);
        }
        this.mibs.addAll(processed);
        int i = 0;
        while (i < processed.size()) {
            try {
                ((Mib)processed.get(i)).initialize();
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < processed.size()) {
            try {
                ((Mib)processed.get(i2)).validate();
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
            ++i2;
        }
        if (log.errorCount() > 0) {
            ((AbstractCollection)this.mibs).removeAll(processed);
        }
        return log;
    }

    private MibSource locate(String name) {
        ClassLoader loader = this.getClass().getClassLoader();
        int i = 0;
        while (i < this.dirs.size()) {
            File dir = (File)this.dirs.get(i);
            File[] files = dir.listFiles(new MibFileFilter(name));
            if (files != null && files.length > 0) {
                return new MibSource(files[0]);
            }
            ++i;
        }
        i = 0;
        while (i < this.resources.size()) {
            URL url = loader.getResource(this.resources.get(i) + "/" + name);
            if (url != null) {
                return new MibSource(name, url);
            }
            ++i;
        }
        return null;
    }

    private class MibFileFilter
    implements FilenameFilter {
        private String basename;

        public MibFileFilter(String name) {
            this.basename = name;
        }

        public boolean accept(File dir, String name) {
            return name.equals(this.basename) || name.startsWith(this.basename + ".");
        }
    }

    private class MibSource {
        private File file = null;
        private URL url = null;
        private Reader input = null;

        public MibSource(File file) {
            this.file = file;
        }

        public MibSource(URL url) {
            this.url = url;
        }

        public MibSource(String name, URL url) {
            this(url);
            this.file = new File(name);
        }

        public MibSource(Reader input) {
            this.input = input;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MibSource) {
                MibSource src = (MibSource)obj;
                if (this.url != null) {
                    return this.url.equals(src.url);
                }
                if (this.file != null) {
                    return this.file.equals(src.file);
                }
            }
            return false;
        }

        public File getFile() {
            return this.file;
        }

        public Mib createMib(MibLoader loader, MibLoaderLog log) throws IOException, MibLoaderException {
            if (this.input != null) {
                return new Mib(this.input, null, loader, log);
            }
            if (this.url != null) {
                this.input = new InputStreamReader(this.url.openStream());
                return new Mib(this.input, this.file, loader, log);
            }
            return new Mib(this.file, loader, log);
        }
    }
}

