/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.browser.AboutDialog;
import net.percederberg.mibble.browser.MibTreeBuilder;
import net.percederberg.mibble.browser.SnmpOperation;
import net.percederberg.mibble.browser.TreeListener;

public class MibbleBrowser
extends JFrame {
    private JMenuItem aboutMenuItem;
    private JButton clearButton;
    private JPanel configPanel;
    private JMenuItem exitMenuItem;
    private JFileChooser fileChooser;
    private JMenu fileMenu;
    private JButton getButton;
    private JButton getNextButton;
    private JMenu helpMenu;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JScrollPane lhsNavigationScrollPane;
    private JMenuItem loadMibMenuItem;
    private JSplitPane mainSplitPane;
    private JMenuBar menuBar;
    private JPanel mibDescriptionPanel;
    private JScrollPane mibDescriptionScrollPane;
    private JTextArea mibDescriptionTextArea;
    private JLabel oidLabel;
    private JTextField oidTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel readCommLabel;
    private JPasswordField readCommPasswordField;
    private JPanel resultPanel;
    private JScrollPane resultScrollPane;
    private JTextArea resultTextArea;
    private JPanel rhsPanel;
    private JButton setButton;
    private JLabel setLabel;
    private JTextField setTextField;
    private JButton snmpWalkButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JMenuItem unloadMibMenuItem;
    private JLabel writeCommLabel;
    private JPasswordField writeCommPasswordField;
    private ArrayList loadedMibsCache;

    public static void main(String[] args) {
        new MibbleBrowser().show();
    }

    public MibbleBrowser() {
        this.initComponents();
        this.loadedMibsCache = new ArrayList();
        this.setJMenuBar(this.menuBar);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setDividerLocation(300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize((int)((double)screenSize.width * 0.9), (int)((double)screenSize.height * 0.75));
        Rectangle frameDim = this.getBounds();
        ((Component)this).setLocation((screenSize.width - frameDim.width) / 2, (screenSize.height - frameDim.height) / 2);
        MibTreeBuilder mb = MibTreeBuilder.getInstance();
        this.lhsNavigationScrollPane.setViewportView(MibTreeBuilder.mibTree);
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadMibMenuItem = new JMenuItem();
        this.unloadMibMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.mainSplitPane = new JSplitPane();
        this.lhsNavigationScrollPane = new JScrollPane();
        this.rhsPanel = new JPanel();
        this.mibDescriptionPanel = new JPanel();
        this.mibDescriptionScrollPane = new JScrollPane();
        this.mibDescriptionTextArea = new JTextArea();
        this.resultPanel = new JPanel();
        this.resultScrollPane = new JScrollPane();
        this.resultTextArea = new JTextArea();
        this.configPanel = new JPanel();
        this.hostLabel = new JLabel();
        this.portTextField = new JTextField();
        this.portLabel = new JLabel();
        this.setLabel = new JLabel();
        this.oidLabel = new JLabel();
        this.setButton = new JButton();
        this.setTextField = new JTextField();
        this.hostTextField = new JTextField();
        this.oidTextField = new JTextField();
        this.readCommLabel = new JLabel();
        this.writeCommLabel = new JLabel();
        this.getButton = new JButton();
        this.readCommPasswordField = new JPasswordField();
        this.writeCommPasswordField = new JPasswordField();
        this.getNextButton = new JButton();
        this.clearButton = new JButton();
        this.snmpWalkButton = new JButton();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel("Ready");
        this.fileMenu.setText("File");
        this.loadMibMenuItem.setText("Load MIB...");
        this.loadMibMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.loadMibMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMibMenuItem);
        this.unloadMibMenuItem.setText("Unload MIB");
        this.unloadMibMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.unloadMibMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.unloadMibMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setTitle("Mibble Browser");
        ((Component)this).setBackground(new Color(255, 255, 204));
        this.setForeground(Color.black);
        this.setName("mbAppFrame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MibbleBrowser.this.exitForm(evt);
            }
        });
        this.lhsNavigationScrollPane.setToolTipText("MIB Tree Navigation");
        this.mainSplitPane.setLeftComponent(this.lhsNavigationScrollPane);
        this.rhsPanel.setLayout(new BorderLayout());
        this.mibDescriptionPanel.setLayout(new BorderLayout());
        this.mibDescriptionScrollPane.setMinimumSize(new Dimension(100, 300));
        this.mibDescriptionScrollPane.setPreferredSize(new Dimension(100, 300));
        this.mibDescriptionScrollPane.setViewportView(this.mibDescriptionTextArea);
        this.mibDescriptionPanel.add((Component)this.mibDescriptionScrollPane, "Center");
        this.rhsPanel.add((Component)this.mibDescriptionPanel, "South");
        this.resultPanel.setLayout(new BorderLayout());
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setLineWrap(true);
        this.resultTextArea.setWrapStyleWord(true);
        this.resultScrollPane.setViewportView(this.resultTextArea);
        this.resultPanel.add((Component)this.resultScrollPane, "Center");
        this.rhsPanel.add((Component)this.resultPanel, "Center");
        this.configPanel.setLayout(new GridBagLayout());
        this.configPanel.setToolTipText("Enter set value");
        this.hostLabel.setText("Host IP Address");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.hostLabel, gridBagConstraints);
        this.portTextField.setColumns(15);
        this.portTextField.setText("161");
        this.portTextField.setToolTipText("Enter ip address");
        this.portTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.portTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.portTextField, gridBagConstraints);
        this.portLabel.setText("Port Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.portLabel, gridBagConstraints);
        this.setLabel.setText("Set Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.setLabel, gridBagConstraints);
        this.oidLabel.setText("OID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.oidLabel, gridBagConstraints);
        this.setButton.setText("Set");
        this.setButton.setToolTipText("Perform SNMP Set");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.setButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.setButton, gridBagConstraints);
        this.setTextField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.setTextField, gridBagConstraints);
        this.hostTextField.setColumns(15);
        this.hostTextField.setText("127.0.0.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.hostTextField, gridBagConstraints);
        this.oidTextField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.oidTextField, gridBagConstraints);
        this.readCommLabel.setText("Read Community");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.readCommLabel, gridBagConstraints);
        this.writeCommLabel.setText("Write Community");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.writeCommLabel, gridBagConstraints);
        this.getButton.setText("Get");
        this.getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.getButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.getButton, gridBagConstraints);
        this.readCommPasswordField.setColumns(8);
        ((JTextComponent)this.readCommPasswordField).setText("public");
        this.readCommPasswordField.setToolTipText("Enter Read Community Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        this.configPanel.add((Component)this.readCommPasswordField, gridBagConstraints);
        this.writeCommPasswordField.setColumns(8);
        ((JTextComponent)this.writeCommPasswordField).setText("public");
        this.writeCommPasswordField.setToolTipText("Enter Write Community Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.configPanel.add((Component)this.writeCommPasswordField, gridBagConstraints);
        this.getNextButton.setText("Get Next");
        this.getNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.getNextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.getNextButton, gridBagConstraints);
        this.clearButton.setText("Clear Result");
        this.clearButton.setToolTipText("Clear Result Area Text");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.clearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.clearButton, gridBagConstraints);
        this.snmpWalkButton.setText("Walk");
        this.snmpWalkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MibbleBrowser.this.snmpWalkButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 7);
        this.configPanel.add((Component)this.snmpWalkButton, gridBagConstraints);
        this.rhsPanel.add((Component)this.configPanel, "North");
        this.mainSplitPane.setRightComponent(this.rhsPanel);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.statusPanel.add(this.statusLabel);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.pack();
    }

    void unloadMibMenuItemActionPerformed(ActionEvent evt) {
        String selectedMibName = this.mibDescriptionTextArea.getText();
        int i = 0;
        while (i < this.loadedMibsCache.size()) {
            if (selectedMibName.equals(this.loadedMibsCache.get(i))) {
                if (MibTreeBuilder.getInstance().unloadMib(selectedMibName)) {
                    this.loadedMibsCache.remove(i);
                }
                return;
            }
            ++i;
        }
    }

    void snmpWalkButtonActionPerformed(ActionEvent evt) {
        SnmpOperation operation = this.createSnmpOperation(true);
        String oidToWalk = this.oidTextField.getText();
        this.resultTextArea.append("\nGetNext: " + operation.snmpWalk(oidToWalk, this.resultTextArea));
    }

    void getNextButtonActionPerformed(ActionEvent evt) {
        SnmpOperation operation = this.createSnmpOperation(true);
        String oidToGet = this.oidTextField.getText();
        this.resultTextArea.append("\nGetNext: " + operation.sendGetNextRequest(oidToGet));
    }

    void clearButtonActionPerformed(ActionEvent evt) {
        this.resultTextArea.setText("");
    }

    void getButtonActionPerformed(ActionEvent evt) {
        SnmpOperation operation = this.createSnmpOperation(true);
        String oidToGet = this.oidTextField.getText();
        this.resultTextArea.append("\nGet: " + operation.sendGetRequest(oidToGet));
    }

    void setButtonActionPerformed(ActionEvent evt) {
        SnmpOperation operation = this.createSnmpOperation(false);
        String oidToSet = this.oidTextField.getText();
        String setValue = this.setTextField.getText();
        operation.sendSetRequest(oidToSet, setValue);
    }

    void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog dialog = new AboutDialog((Frame)this, true);
        dialog.show();
    }

    void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    void loadMibMenuItemActionPerformed(ActionEvent evt) {
        this.statusLabel.setText("Loading MIB...");
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.showOpenDialog(this);
        File[] selFiles = this.fileChooser.getSelectedFiles();
        Mib mib = null;
        MibTreeBuilder mb = MibTreeBuilder.getInstance();
        StringBuffer namesOfMibsLoaded = new StringBuffer();
        boolean alreadyLoaded = false;
        int i = 0;
        while (i < selFiles.length) {
            block8: {
                try {
                    mib = mb.loadMib(selFiles[i]);
                }
                catch (MibLoaderException e) {
                    e.getLog().printTo(System.err);
                    this.resultTextArea.append(e.getMessage());
                    break block8;
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    this.resultTextArea.append(e.getMessage());
                    break block8;
                }
                int j = 0;
                while (j < this.loadedMibsCache.size()) {
                    if (mib.getName().equals((String)this.loadedMibsCache.get(j))) {
                        this.statusLabel.setText(mib.getName() + " Already Loaded.");
                        alreadyLoaded = true;
                        break;
                    }
                    ++j;
                }
                if (alreadyLoaded) {
                    alreadyLoaded = false;
                } else {
                    mb.addMib(mib);
                    MibTreeBuilder.mibTree.addTreeSelectionListener(new TreeListener(MibTreeBuilder.mibTree, this.oidTextField, this.mibDescriptionTextArea));
                    this.loadedMibsCache.add(mib.getName());
                    namesOfMibsLoaded.append(mib.getName() + ", ");
                }
            }
            ++i;
        }
        this.statusLabel.setText(namesOfMibsLoaded.toString() + " Loaded.");
        ((DefaultTreeModel)MibTreeBuilder.mibTree.getModel()).reload();
        MibTreeBuilder.mibTree.repaint();
    }

    void portTextFieldActionPerformed(ActionEvent evt) {
    }

    void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private SnmpOperation createSnmpOperation(boolean read) {
        String host = this.hostTextField.getText();
        int port = 0;
        try {
            port = Integer.parseInt(this.portTextField.getText());
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            String message = "Error: Provide valid (numeric) port number in the range [0..65536].";
            JOptionPane.showMessageDialog(this, message);
            return null;
        }
        if (port < 0 || port > 65536) {
            String message = "Error: Provide valid (numeric) port number in the range [0..65536].";
            JOptionPane.showMessageDialog(this, message);
            return null;
        }
        String community = read ? new String(this.readCommPasswordField.getPassword()) : new String(this.writeCommPasswordField.getPassword());
        return new SnmpOperation(host, port, community);
    }
}

