/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibbleTester {
    public static void main(String[] args) {
        Mib mib;
        MibLoader loader = new MibLoader();
        int errors = 0;
        int warnings = 0;
        if (args.length < 1) {
            MibbleTester.printHelp("No file(s) specified");
            System.exit(1);
        }
        int i = 0;
        while (i < args.length) {
            try {
                System.out.print("Reading " + args[i] + "... ");
                System.out.flush();
                File file = new File(args[i]);
                loader.addDir(file.getParentFile());
                mib = loader.load(file);
                System.out.println("[OK]");
                if (mib.getLog().warningCount() > 0) {
                    mib.getLog().printTo(System.out);
                    ++warnings;
                }
            }
            catch (IOException e) {
                System.out.println("[FAILED]");
                MibbleTester.printError(args[i], e);
                ++errors;
            }
            catch (MibLoaderException e) {
                System.out.println("[FAILED]");
                e.getLog().printTo(System.out);
                ++errors;
            }
            catch (RuntimeException e) {
                System.out.println();
                MibbleTester.printInternalError(e);
                System.exit(1);
            }
            ++i;
        }
        mib = loader.getMib("TCP-MIB");
        MibValueSymbol sym = (MibValueSymbol)mib.getSymbol("tcpConnEntry");
        ObjectIdentifierValue oid = (ObjectIdentifierValue)sym.getValue();
        System.out.println("Parent: " + oid);
        int i2 = 0;
        while (i2 < oid.getChildCount()) {
            System.out.println("Child:  " + oid.getChild(i2));
            ++i2;
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        e.printStackTrace();
    }

    private static void printError(String file, IOException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }
}

