/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.io.IOException;
import javax.swing.JTextArea;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.pdu.OneSetPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextPool;
import uk.co.westhawk.snmp.stack.varbind;

public class SnmpOperation {
    private SnmpContextPool context;

    public SnmpOperation(String host, int port, String comm) {
        this.createContext(host, port, comm);
    }

    private void createContext(String host, int port, String comm) {
        if (this.context != null) {
            this.context.destroy();
        }
        try {
            this.context = new SnmpContextPool(host, port, "Standard");
            this.context.setCommunity(comm);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public String sendGetRequest(String oid) {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.context);
        pdu.setPduType(0);
        pdu.addOid(oid);
        return this.sendRequest(pdu);
    }

    public String sendGetNextRequest(String oid) {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.context);
        pdu.setPduType(2);
        pdu.addOid(oid);
        return this.sendRequest(pdu);
    }

    public void sendSetRequest(String oid, String value) {
        OneSetPdu oneSetPdu = new OneSetPdu((SnmpContextBasisFace)this.context);
        Object obj = this.isNumber(value) ? new AsnInteger(Integer.parseInt(value)) : new AsnOctets(value);
        oneSetPdu.addOid(oid, (AsnObject)obj);
        this.sendRequestSet((Pdu)oneSetPdu);
    }

    private String sendRequest(BlockPdu pdu) {
        try {
            varbind var;
            if (pdu != null && (var = pdu.getResponseVariableBinding()) != null) {
                AsnObjectId oid = var.getOid();
                AsnObject res = var.getValue();
                if (res != null) {
                    return oid.toString() + "--> " + res.toString();
                }
                return "ERR";
            }
        }
        catch (PduException exc) {
            if (exc.getMessage().equals("No such name error")) {
                return "No such name error";
            }
            return "ERR";
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return "";
    }

    private void sendRequestSet(Pdu pdu) {
        try {
            pdu.send();
        }
        catch (PduException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String snmpWalk(String oid, JTextArea resultArea) {
        BlockPdu pdu = new BlockPdu((SnmpContextBasisFace)this.context);
        pdu = new BlockPdu((SnmpContextBasisFace)this.context);
        pdu.setPduType(2);
        pdu.addOid(oid);
        try {
            while (pdu != null) {
                varbind var = pdu.getResponseVariableBinding();
                if (var == null) continue;
                AsnObjectId oidNext = var.getOid();
                AsnObject res = var.getValue();
                if (res.getRespType() == -126) return "$$2";
                if (res == null) return "$$1";
                if (oidNext == null) return "$$1";
                if (oidNext.toString().indexOf(oid) == -1) {
                    return "END OF WALK";
                }
                resultArea.append("\n" + oidNext.toString() + "--> " + res.toString());
                pdu = new BlockPdu((SnmpContextBasisFace)this.context);
                pdu.setPduType(2);
                pdu.addOid(oidNext.toString());
            }
            return "$$3";
        }
        catch (PduException exc1) {
            exc1.printStackTrace();
            return "END OF MIB";
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return "END OF MIB";
        }
    }

    private boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

