/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.type.Constraint;

public class SnmpTextualConvention
extends MibType
implements MibContext {
    private String displayHint;
    private SnmpStatus status;
    private String description;
    private String reference;
    private MibType syntax;

    public SnmpTextualConvention(String displayHint, SnmpStatus status, String description, String reference, MibType syntax) {
        super("TEXTUAL-CONVENTION", false);
        this.displayHint = displayHint;
        this.status = status;
        this.description = description;
        this.reference = reference;
        this.syntax = syntax;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        this.syntax = this.syntax.initialize(symbol, log);
        return this;
    }

    public MibType createReference() throws UnsupportedOperationException {
        return this.syntax.createReference();
    }

    public MibType createReference(Constraint constraint) throws UnsupportedOperationException {
        return this.syntax.createReference(constraint);
    }

    public MibType createReference(ArrayList values) throws UnsupportedOperationException {
        return this.syntax.createReference(values);
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibSymbol getSymbol(String name) {
        if (this.syntax instanceof MibContext) {
            return ((MibContext)((Object)this.syntax)).getSymbol(name);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        if (this.displayHint != null) {
            buffer.append("\n  Display-Hint: ");
            buffer.append(this.displayHint);
        }
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.description);
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n  Syntax: ");
        buffer.append(this.syntax);
        buffer.append("\n)");
        return buffer.toString();
    }
}

