/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.ElementType;

public class SequenceType
extends MibType {
    private ArrayList elements;

    public SequenceType(ArrayList elements) {
        this(true, elements);
    }

    private SequenceType(boolean primitive, ArrayList elements) {
        super("SEQUENCE", primitive);
        this.elements = elements;
        this.setTag(true, MibTypeTag.SEQUENCE);
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        int i = 0;
        while (i < this.elements.size()) {
            ElementType elem = (ElementType)this.elements.get(i);
            elem.initialize(symbol, log);
            ++i;
        }
        return this;
    }

    public MibType createReference() {
        SequenceType type = new SequenceType(false, this.elements);
        type.setTag(true, this.getTag());
        return type;
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public ElementType[] getAllElements() {
        ElementType[] res = new ElementType[this.elements.size()];
        this.elements.toArray(res);
        return res;
    }

    public String toString() {
        return super.toString() + " " + this.elements.toString();
    }
}

