/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ValueReference;

public class ObjectIdentifierValue
extends MibValue {
    private MibValue parent;
    private ArrayList children = new ArrayList();
    private String name;
    private int value;
    private MibValueSymbol symbol = null;

    public ObjectIdentifierValue(String name, int value) {
        super("OBJECT IDENTIFIER");
        this.parent = null;
        this.name = name;
        this.value = value;
    }

    public ObjectIdentifierValue(ObjectIdentifierValue parent, String name, int value) {
        super("OBJECT IDENTIFIER");
        this.parent = parent;
        this.name = name;
        this.value = value;
        parent.addChild(this);
    }

    public ObjectIdentifierValue(ValueReference parent, String name, int value) {
        super("OBJECT IDENTIFIER");
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    public MibValue initialize(MibLoaderLog log) throws MibException {
        ValueReference ref = null;
        if (this.parent == null) {
            return this;
        }
        if (this.parent instanceof ValueReference) {
            ref = (ValueReference)this.parent;
        }
        this.parent = this.parent.initialize(log);
        if (ref != null) {
            if (this.parent instanceof ObjectIdentifierValue) {
                ((ObjectIdentifierValue)this.parent).addChild(this);
            } else {
                throw new MibException(ref.getLocation(), "referenced value is not an object identifier");
            }
        }
        return this;
    }

    public MibValue createReference() {
        return this;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ObjectIdentifierValue getParent() {
        if (this.parent != null && this.parent instanceof ObjectIdentifierValue) {
            return (ObjectIdentifierValue)this.parent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public MibValueSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(MibValueSymbol symbol) {
        if (this.name == null) {
            this.name = symbol.getName();
        }
        this.symbol = symbol;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ObjectIdentifierValue getChild(int index) {
        return (ObjectIdentifierValue)this.children.get(index);
    }

    public ObjectIdentifierValue[] getAllChildren() {
        ObjectIdentifierValue[] values = new ObjectIdentifierValue[this.children.size()];
        this.children.toArray(values);
        return values;
    }

    private void addChild(ObjectIdentifierValue child) {
        int i = this.children.size();
        while (i > 0) {
            ObjectIdentifierValue value = (ObjectIdentifierValue)this.children.get(i - 1);
            if (value.getValue() == child.getValue()) {
                return;
            }
            if (value.getValue() < child.getValue()) break;
            --i;
        }
        this.children.add(i, child);
    }

    public Object toObject() {
        return this.toString();
    }

    public String toString() {
        if (this.parent == null) {
            return String.valueOf(this.value);
        }
        return this.parent.toString() + "." + String.valueOf(this.value);
    }

    public String toDetailString() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent instanceof ObjectIdentifierValue) {
            buffer.append(((ObjectIdentifierValue)this.parent).toDetailString());
            buffer.append(".");
        }
        if (this.name == null) {
            buffer.append(this.value);
        } else {
            buffer.append(this.name);
            buffer.append("(");
            buffer.append(this.value);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

