/* ipc_internal.h - Generalized interprocess communication 
 *
 * Copyright (C) 2004-2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IPC_INTERNAL_H
#define IPC_INTERNAL_H

#include <stdbool.h>
#include <stdint.h>
#include <unistd.h>
#include "ipc.h"

typedef struct _IPCMessageHeader IPCMessageHeader;
typedef union _IPCArgValue IPCArgValue;
typedef union _IPCArgRef IPCArgRef;

union _IPCArgRef {
    uint64_t *t_int64;
    uint32_t *t_int32;
    int *t_int;
    bool *t_bool;
    char **t_str;
};

union _IPCArgValue {
    uint64_t t_int64;
    uint32_t t_int32;
    int t_int;
    bool t_bool;
    struct {
    	ssize_t len;
    	char *chars;
    } t_str;
};

struct _IPCMessageHeader {
    uint32_t id;
    uint32_t size;
    uint32_t arg_count;
};

struct _IPC {
    int fd;
    void *userdata;
    bool has_header;
    IPCMessageHeader header;
    IPCMessageFunction handle_message;
    IPCErrorFunction handle_error;
};

#endif
