/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016 John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#ifndef BDC_H
#define BDC_H

#include <stdint.h>

#include "upad.h"

#include "periph/gpio.h"

enum
  {
    NOP,
    ACK_DISABLE,
    ACK_ENABLE,
    GO,
    STEP,
    BACKGROUND,
    READ_R,
    WRITE_R,
    READ_BYTE,
    DUMP_BYTE,
    READ_WORD,
    DUMP_WORD,
    READ_DWORD,
    DUMP_DWORD,
    WRITE_BYTE,
    FILL_BYTE,
    WRITE_WORD,
    FILL_WORD,
    WRITE_DWORD,
    FILL_DWORD,
    READ_BDCCSR,
    WRITE_BDCCSR,
    ERASE_FLASH,
    n_BDC_CMDS
  };

int bdc_sync (uint32_t *sync_time);

uint16_t bdc_read_bdccsr (void);

void bdc_bulk_erase (void);

void bdc_write_bdccsr (uint16_t value);

void bdc_read_byte (uint32_t address, uint8_t *byte);
void bdc_read_double_byte (uint32_t address, uint8_t *byte);
void bdc_read_quad_byte (uint32_t address, uint8_t *byte);

uint16_t bdc_read_word (uint32_t address);
uint32_t bdc_read_dword (uint32_t address);

void bdc_dump_byte (uint8_t *byte);
void bdc_dump_double_byte (uint8_t *byte);
void bdc_dump_quad_byte (uint8_t *byte);

uint16_t bdc_dump_word (void);
uint32_t bdc_dump_dword (void);

void bdc_write_octet (uint32_t address, uint8_t value);
void bdc_write_word (uint32_t address, uint16_t value);
void bdc_write_dword (uint32_t address, uint32_t value);

void bdc_write_byte (uint32_t address, const uint8_t *value);
void bdc_write_double_byte (uint32_t address, const uint8_t *value);
void bdc_write_quad_byte (uint32_t address, const uint8_t *value);

void bdc_fill_word (uint16_t value);
void bdc_fill_dword (uint32_t value);

void bdc_fill_byte (const uint8_t *value);
void bdc_fill_double_byte (const uint8_t *value);
void bdc_fill_quad_byte (const uint8_t *value);

uint32_t bdc_read_register (int reg);
void bdc_write_register (int reg, uint32_t value);

void bdc_go (void);
void bdc_step (void);
void bdc_background (void);

void bdc_calibrate (uint32_t period);

void bdc_delay (void);

static inline void
bkgd_talk (void)
{
  gpio_init (BKGD_PIN, GPIO_OD);
}

static inline void
bkgd_listen (void)
{
  gpio_init (BKGD_PIN, GPIO_IN);
}

#endif


