/*
  Copyright (C) 2016 John Darrington

  Copying and distribution of this file, with or without modification,
  are permitted in any medium without royalty provided the copyright
  notice and this notice are preserved.  This file is offered as-is,
  without any warranty.
*/
#include <stdint.h>

#define __IOM volatile
#define __IM volatile const
#define __OM volatile

typedef struct
{
    __IOM uint8_t   C[2];                   /*!< 0x0100 */
    __IM  uint8_t   RESERVED0[5];           /*!< 0x0102 */
    __IOM uint8_t   SCR[3];                 /*!< 0x0107 */
    __IM  uint8_t   EFR;                    /*!< 0x010A */
    __IM  uint8_t   GSR;                    /*!< 0x010B */
    __IM  uint8_t   RESERVED1[4];           /*!< 0x010C */
    __IOM uint8_t   ACTL;                   /*!< 0x0110 */
    __IM  uint8_t   RESERVED2[2];           /*!< 0x0111 */
    __IOM uint32_t  AA;                     /*!< 0x0114 */
    __IOM uint32_t  AD;                     /*!< 0x0118 */
    __IOM uint32_t  ADM;                    /*!< 0x011C */
    __IOM uint8_t   BCTL;                   /*!< 0x0120 */
    __IM  uint8_t   RESERVED3[2];           /*!< 0x0121 */
    __IOM uint32_t  BA;                     /*!< 0x0124 */
    __IM  uint8_t   RESERVED4[24];          /*!< 0x0128 */
    __IOM uint8_t   DCTL;                   /*!< 0x0140 */
    __IM  uint8_t   RESERVED5[3];           /*!< 0x0141 */
    __IOM uint32_t  DA;                     /*!< 0x0144 */
    __IM  uint8_t   RESERVED6[7];           /*!< 0x0148 */
} DBG_TypeDef;

#define DBG_BASE (0x0100U)
#define DBG ((DBG_TypeDef *) DBG_BASE)
