/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016, 2019 John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#ifndef SEP_H
#define SEP_H

#include <stdint.h>

#define SEP_START ((uint8_t)'s')
#define MAX_PAYLOAD_LENGTH 0x108
#define MAX_PACKET_LENGTH ((MAX_PAYLOAD_LENGTH + 2 + 2) * 2 + 1)
/*                                                            ^ start
                                                          ^ padding
                                                     ^ crc
                                                 ^ length
*/

#define htonl(X) (X)
#define htons(X) (X)
#define ntohs(X) (X)

static inline uint16_t
crc16_update (uint16_t crc, uint8_t a)
{
  int i;

  crc ^= a;
  for (i = 0; i < 8; ++i)
    {
      if (crc & 1)
	crc = (crc >> 1) ^ 0xA001;
      else
	crc = (crc >> 1);
    }

  return crc;
}

struct write_mem_params
{
  uint32_t address;
  uint16_t quantity;
  uint8_t data[0];
} __attribute__ ((packed));


#endif

/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
