/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __BREAKPOINTS_H
#define __BREAKPOINTS_H

#include <stdbool.h>
#include <stdint.h>

#include "upad.h"

enum bp_type
{
    BP_NONE,
    BP_BREAK,  /* Breakpoint */
    BP_WATCH   /* Watchpoint */
};

/* Arm all breakpoints */
void arm_breakpoints (int dev);

/* Disarm all breakpoints */
void disarm_breakpoints (int dev);

/* Insert a breakpoint at ADDRESS */
bool bp_insert (int dev, tgt_addr address, enum bp_type type);

/* Remove a breakpoint (if any) from ADDRESS */
bool bp_remove (int dev, tgt_addr address);

/* Return true iff any breakpoints are set. */
bool breakpoints_active (void);

/* Return non-zero if at least one breakpoint event occured since the
   module was armed.  */
uint8_t breakpoint_fired (int dev);

/* Return an indication of the BP_TYPE of the breakpoint in SET.
   If SET contains more than one breakpoint, then prefer the
   one that is BP_BREAK over BP_WATCH.  */
enum bp_type breakpoint_type_in_set (int dev, uint8_t set);

#endif


/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
