/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GDB_CMDS_H
#define GDB_CMDS_H

#include <stddef.h>

struct gdb_cmd
{
  const char *name;
  void (*funx) (const char *cmd, int conn, int dev);
};


/* Detach */
void gdb_detach (const char *cmd, int conn, int dev);

/* Writes all registers in one operation.  */
void gdb_write_registers (const char *cmd, int conn, int dev);

void gdb_kill (const char *cmd, int conn, int dev);

/* Writes a location in memory on the target.  */
void gdb_write_memory (const char *cmd, int conn, int dev);

/*  Reads all the registers in one operation.  */
void gdb_read_registers (const char *cmd, int conn, int dev);

/* Reads data from memory on the target.  */
void gdb_read_memory (const char *cmd, int conn, int dev);


/* Reads a single register from the target.  */
void gdb_read_register (const char *cmd, int conn, int dev);

/* Writes a single register to the target.  */
void gdb_write_register (const char *cmd, int conn, int dev);

/* Sets a breakpoint on the target.  */
void gdb_insert_breakpoint (const char *cmd, int conn, int dev);

/* Removes a breakpoint from the target.  */
void gdb_remove_breakpoint (const char *cmd, int conn, int dev);

/* Single instruction step.  */
void gdb_step (const char *cmd, int conn, int dev);

/* Set the target running.  */
void gdb_vrun (const char *ccmd, int conn, int dev);

/* Enter or leave non-stop mode.  */
void gdb_nonstop (const char *cmd, int conn, int dev);

/* Indicate to GDB whether we have restarted the target since
   we attached.  */
void gdb_attached (const char *cmd, int conn, int dev);

/* Set the CPU running starting at the current PC.  */
void gdb_continue (const char *cmd, int conn, int dev);

void gdb_rcmd (const char *cmd, int conn, int dev);

/* Transfer the target's memory map.  */
void gdb_memory_map (const char *cmd, int conn, int dev);

/* Starts no ack mode.  */
void gdb_start_no_ack (const char *cmd, int conn, int dev);

void gdb_positive_ack (const char *cmd, int conn, int dev);

void gdb_supported (const char *cmd, int conn, int dev);

void gdb_restart (const char *cmd, int conn, int dev);

#endif
