/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __GDB_INTERFACE_H
#define __GDB_INTERFACE_H

#include <stdbool.h>

void process_gdb_message (int conn, const char bcmd, int dev);

struct gdb_svr;

int accept_gdb_connection (struct gdb_svr *);

struct gdb_svr * create_gdb_server (const char *connection_point);
int gdb_svr_conn_fd (const struct gdb_svr *);
void destroy_gdb_server (struct gdb_svr *);

void close_gdb_connection (int conn);

void destroy_gdb_connection (struct gdb_svr);

void gdb_connection_initialize (int conn, int des);


void gdb_send_interrupt (int conn, int dev);

void gdb_send_broken (int conn, int dev);
void gdb_send_stopped (int conn, int dev);
bool gdb_send_ping (int conn);

void gdb_positive_ack (const char *cmd, int conn, int dev);


#endif


/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
