/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MISC_H
#define __MISC_H

#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

static inline  void *
safe_realloc (void *ptr, size_t size)
{
  void *new_ptr = realloc (ptr, size);
  if (!new_ptr)
    abort ();
  return new_ptr;
}

enum msglevel
  {
    MSG_FATAL = 0,
    MSG_ERROR,
    MSG_WARNING,
    MSG_INFORMATION,
    MSG_NOTE,
    MSG_DIAGNOSTIC
  };

void upad_msg (enum msglevel, const char *fmt, ...)
  __attribute__ ((format (printf, 2, 3)));
void upad_errno (enum msglevel lvl, const char *fmt, ...)
  __attribute__ ((format (printf, 2, 3)));

bool process_command (const char *cmd, int fpr);

struct bounce_code_usage;
struct upload_format;
int upload_format (int des, struct upload_format *uf, const struct bounce_code_usage
		   *bcu);


struct user_options;
void canonicalise_control_file (struct user_options *opts);


#endif


/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
