/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __OPTIONS_H
#define __OPTIONS_H

struct user_options
{
  /* The port to which the controller is connected */
  const char *port;

  /* Set if the only operation to be performed is a bulk erase */
  bool erase_only;

  /* Start with an interactive user interface */
  bool interactive;

  /* Set if the target should not be reset after programming */
  bool no_reset;

  /* The script file name to be run, or NULL */
  const char *script;

  /* The name of the file to be uploaded */
  const char *file;

  /* True if the file to be uploaded is a binary file (ie not S-record and not elf) */
  bool binary;

  /* The address where to load the file  (relevant for binary files only).  */
  uint32_t load_address;

  /* The name of the file which contains the bounce code */
  const char *bounce_code;

  /* The port on which to listen for gdb connections, or the name of a AF_UNIX socket. */
  char *gdb_port;

  /* Whether a gdb server should run.  */
  bool gdb_server;

  /* True if a gdb server should run in the background.  */
  bool start_server;

  char *control_file;

  /* True if an gdb existing server should be halted.  */
  bool stop_server;

  /* Do not display the copyright and licence message on startup.  */
  bool no_splash;
};

void parse_options (int argc, char **argv, struct user_options *opts);

#endif
