/*
  Copyright (C) 2016, 2019 John Darrington

  Copying and distribution of this file, with or without modification,
  are permitted in any medium without royalty provided the copyright
  notice and this notice are preserved.  This file is offered as-is,
  without any warranty.
*/
#include <stdint.h>


typedef struct
{
    __IM  uint8_t   RESERVED0[3];           /*!< 0x06C0 */
    __IM  uint8_t   RFLG;                   /*!< 0x06C3 */
    __IOM uint8_t   SYNR;                   /*!< 0x06C4 */
    __IOM uint8_t   REFDIV;                 /*!< 0x06C5 */
    __IOM uint8_t   POSTDIV;                /*!< 0x06C6 */
    __IOM uint8_t   IFLG;                   /*!< 0x06C7 */
    __IOM uint8_t   INT;                    /*!< 0x06C8 */
    __IOM uint8_t   CLKS;                   /*!< 0x06C9 */
    __IOM uint8_t   PLL;                    /*!< 0x06CA */
    __IOM uint8_t   RTI;                    /*!< 0x06CB */

    __IOM uint8_t   COP;                    /*!< 0x06CC */
    __IM  uint8_t   RESERVED1[2];           /*!< 0x06CD */

    __IOM uint8_t   ARMCOP;                 /*!< 0x06CF */
    __IOM uint8_t   HTCTL;                  /*!< 0x06D0 */

    __IOM uint8_t   LVCTL;                  /*!< 0x06D1 */
    __IOM uint8_t   APICTL;                 /*!< 0x06D2 */
    __IOM uint8_t   ACLKTR;                 /*!< 0x06D3 */
    __IOM uint16_t  APIR;                   /*!< 0x06D4 */

    __IM  uint8_t   RESERVED2;              /*!< 0x06D6 */

    __IOM uint8_t   HTTR;                   /*!< 0x06D7 */
    __IOM uint16_t  IRCTRIM;                /*!< 0x06D8 */

    __IOM uint8_t   OSC;                    /*!< 0x06DA */
    __IOM uint8_t   PROT;                   /*!< 0x06DB */
    __IM  uint8_t   RESERVED3;              /*!< 0x06DC */
    __IOM uint8_t   VREGCTRL;               /*!< 0x06DD */

    __IOM uint8_t   RESERVED4[2];           /*!< 0x06DE */

} CPMU_TypeDef;

#define CPMU_BASE (0x06C0U)
#define CPMU ((CPMU_TypeDef *) CPMU_BASE)
