#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: Checks that S-Record files can be uploaded.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

$top_srcdir/test/gensrec.sh -a FFFFFC -d 12345678 > $tempdir/one.srec
if test $? -ne 0; then fail; fi

$BINARY --no-bounce $tempdir/one.srec
if test $? -ne 0; then fail; fi

cat <<EOF  > $tempdir/cmds
reset-bdm
sync
read-mem 0xFFFFD0 0x30
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds > $tempdir/result
if test $? -ne 0; then no_result; fi

diff $tempdir/result - <<EOF
00FFFFD0:  ........ ........   FF FF FF FF FF FF FF FF   FF FF FF FF FF FF FF FF
00FFFFE0:  ........ ........   FF FF FF FF FF FF FF FF   FF FF FF FF FF FF FF FF
00FFFFF0:  ........ .....4Vx   FF FF FF FF FF FF FF FF   FF FF FF FF 12 34 56 78
EOF
if test $? -ne 0; then fail; fi

pass
