#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: Tests for a bug where a later S-record would get overwritten
#purpose: by an earlier one

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}


cat <<EOF  > $tempdir/cmds
reset-bdm
sync
read-mem 0xFFFFC0 0x40
EOF
if test $? -ne 0; then no_result; fi

cat <<EOF > $tempdir/x.srec
S214FFFFE0005000000060000000700000008000006D
S210FFFFF00090000000A0000000B0000021
EOF

$BINARY --no-bounce $tempdir/x.srec
if test $? -ne 0; then fail; fi

$BINARY --no-bounce -T $tempdir/cmds | tail -4 > $tempdir/result
if test $? -ne 0; then no_result; fi

diff $tempdir/result - << 'EOF'
00FFFFC0:  ........ ........   FF FF FF FF FF FF FF FF   FF FF FF FF FF FF FF FF
00FFFFD0:  ........ ........   FF FF FF FF FF FF FF FF   FF FF FF FF FF FF FF FF
00FFFFE0:  .P...`.. .p......   00 50 00 00 00 60 00 00   00 70 00 00 00 80 00 00
00FFFFF0:  ........ ........   00 90 00 00 00 A0 00 00   00 B0 00 00 FF FF FF FF
EOF
if test $? -ne 0; then fail; fi

pass
