#!/bin/bash
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test makes sure that small parts of RAM can be written
#purpose: without error.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

cat <<EOF  > $tempdir/testfile
There once was a man who said God,
Would find it exceedingly odd,
If in the quad, that tree,
Should continue to be,
When no-one's around in the Quad.
EOF
if test $? -ne 0; then no_result; fi

bytes=`wc -c $tempdir/testfile | awk '{print $1}'`

cat <<EOF  > $tempdir/cmds
reset-bdm
sync
write-mem 0x1000 $[bytes + 6] 0xFF
upload-binary $tempdir/testfile 0x1003
read-mem 0x1000 $[bytes + 6]
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds > $tempdir/ref
if test $? -ne 0; then no_result; fi

diff $tempdir/ref - <<EOF
00001000:  ...There  once wa   FF FF FF 54 68 65 72 65   20 6F 6E 63 65 20 77 61
00001010:  s a man  who said   73 20 61 20 6D 61 6E 20   77 68 6F 20 73 61 69 64
00001020:   God,.Wo uld find   20 47 6F 64 2C 0A 57 6F   75 6C 64 20 66 69 6E 64
00001030:   it exce edingly    20 69 74 20 65 78 63 65   65 64 69 6E 67 6C 79 20
00001040:  odd,.If  in the q   6F 64 64 2C 0A 49 66 20   69 6E 20 74 68 65 20 71
00001050:  uad, tha t tree,.   75 61 64 2C 20 74 68 61   74 20 74 72 65 65 2C 0A
00001060:  Should c ontinue    53 68 6F 75 6C 64 20 63   6F 6E 74 69 6E 75 65 20
00001070:  to be,.W hen no-o   74 6F 20 62 65 2C 0A 57   68 65 6E 20 6E 6F 2D 6F
00001080:  ne's aro und in t   6E 65 27 73 20 61 72 6F   75 6E 64 20 69 6E 20 74
00001090:  he Quad. ....       68 65 20 51 75 61 64 2E   0A FF FF FF            
EOF
if test $? -ne 0; then fail; fi

pass
