#!/bin/bash
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test checks that upad can be started and stopped (using
#purpose: --start-server / --stop-server) when the argument is a directory.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}


$BINARY --start-server=$tempdir
if test $? -ne 0; then fail; fi

pid=`awk '/pid:/{print $2}' $tempdir/ctrl`

# Check that the process exists
if test ! -f /proc/$pid/status ; then fail ; fi

$BINARY --stop-server=$tempdir
if test $? -ne 0; then fail; fi

# Check that the file really is dead
cat /proc/$pid/status 2>&1 > /dev/null

# Check that the process no longer exists
if test -f /proc/$pid/status ; then fail ; fi


pass
