/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef USER_INTERFACE_H
#define USER_INTERFACE_H

#include <stdbool.h>

struct user_options;

enum ARG_TYPE
{
    ARG_ADDRESS,
    ARG_QUANTITY,
    ARG_FILENAME,
    ARG_DATUM
};

struct xcmd
{
  char *name;
  int (*call) (int fpr, int argc, char **argv);
  int n_args;
  const enum ARG_TYPE *args;
};

#define N_COMMANDS 24

extern const struct xcmd cmds[];


struct user_interface
{
  /* A buffer to contain the expanded (that is to say after
     filename and other expansion has been done)  command. */
  char *cmd;

  /* The length of CMD (not including the terminating null). */
  int cmd_length;


  /* The file descriptor for communicating with the controller. */
  int xxdes;

  /* A flag which is true, iff the user interface is running. */
  bool running;

  /* The name of the file containing the command history. */
  char *histfile;

  /* The file descriptor used by readline to service the user interface */
  int ui_des;
};


struct user_interface *user_interface_init (const struct user_options *);
void user_interface_shutdown (struct user_interface *ui);
void user_interface_process (struct user_interface *ui);


#endif

/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
