# This file is part of mingw-cross-env.
# See doc/index.html for further information.

# libodbc++
PKG             := libodbc++
$(PKG)_IGNORE   :=
$(PKG)_VERSION  := 0.2.5
$(PKG)_CHECKSUM := 8a77921b21c23926042c413f4a7a187a3656025b
$(PKG)_SUBDIR   := libodbc++-$($(PKG)_VERSION)
$(PKG)_FILE     := libodbc++-$($(PKG)_VERSION).tar.bz2
$(PKG)_WEBSITE  := http://libodbcxx.sourceforge.net/
$(PKG)_URL      := http://$(SOURCEFORGE_MIRROR)/project/libodbcxx/libodbc++/$($(PKG)_VERSION)/$($(PKG)_FILE)
$(PKG)_DEPS     := gcc

define $(PKG)_UPDATE
    wget -q -O- 'http://libodbcxx.svn.sourceforge.net/viewvc/libodbcxx/tags/?sortby=date' | \
    grep '<a name="' | \
    $(SED) -n 's,.*<a name="libodbc++-\([0-9][^"]*\)".*,\1,p' | \
    head -1
endef

define $(PKG)_BUILD
    cd '$(1)' && autoconf
    touch '$(1)/aclocal.m4'
    touch '$(1)/Makefile.in'
    touch '$(1)/config.h.in'
    cd '$(1)' && ./configure \
      --prefix='$(PREFIX)/$(TARGET)' \
      --host='$(TARGET)' \
      --disable-shared \
      --without-tests \
      --disable-dependency-tracking
    $(MAKE) -C '$(1)' -j '$(JOBS)' install doxygen= progref_dist_files=
endef
