<?php
  /**
   * MiniClick
   * Gestionnaire de tableau collaboratif
   * Copyright (C) 2006 Guillaume Monet <gm@ibreizh.net>
   *
   * This program is free software; you can redistribute it and/or modify
   * it under the terms of the GNU General Public License as published by
   * the Free Software Foundation; either version 2 of the License, or
   * any later version.
   *
   * This program is distributed in the hope that it will be useful,
   * but WITHOUT ANY WARRANTY; without even the implied warranty of
   * MERCHANTABILITY or FITNESS FR A PARTICULAR PURPOSE. See the
   * GNU General Public License for more details.
   *
   * You should have received a copy of the GNU General Public License
   * along with this program; if not, write to the Free Software
   * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA 
   *
   * @package miniclick
   * @version 5.0.0
   */
session_start();

include("includes/config.php");
include("includes/db/db_interface.php");

include("engine/miniclic/user.class.php");

require(SMARTY_LIBS_DIR.'Smarty.class.php');
$smarty = new Smarty;
$smarty->template_dir = SMARTY_TEMPLATE_DIR;
$smarty->compile_dir = SMARTY_COMPILE_DIR;
$smarty->config_dir = SMARTY_CONFIG_DIR;
$smarty->cache_dir = SMARTY_CACHE_DIR;
$smarty->plugins_dir = SMARTY_PLUGINS_DIR;

$db = db_interface::getInstance();
$db->db_connect();
$db->db_select(DB_NAME);

/*
function mysql_current_db() {
mysql_selectdb    $r = mysql_query("SELECT DATABASE()") or die(mysql_error());
    return mysql_result($r,0);
}
*/

//Verification de l'utilisateur
if(isset($_POST['password']) && isset($_POST['user_id'])){
  include("includes/check_login.php");
 }

if($_SESSION['user_id'] == "")
  {
    $smarty->assign('page',"index.php");
    $smarty->display('redirect.tpl');
    die("Fin de la session");
  }

if($_GET['application'] !="")
  {
    $_SESSION['app_id'] = $_GET['application'];
  }

  
if( is_numeric($_GET['module_id']) )
	{
	$sql_query = "SELECT m.*,a.Db as `dataBase`,a.App_id as App_id FROM ".DB_NAME.".APP a, ".DB_NAME.".MODULE m WHERE m.App_Id=a.App_Id AND m.Module_Id='".$_GET['module_id']."'" ;
	$r = $db->db_query($sql_query);
	$v = $db->db_fetch_object($r);
	$_SESSION['app_id'] = $v->App_id ; 
	}
  
  
$sql_query = "SELECT ".DB_NAME.".APP.App_Id,"
  .DB_NAME.".APP.Nom AS App_Name,".DB_NAME.".APP.Host,"
  .DB_NAME.".APP.Db,".DB_NAME.".APP_ACCESS.Role_Id, "
  .DB_NAME.".ROLE.Nom AS Role_Name FROM "
  .DB_NAME.".APP,".DB_NAME.".APP_ACCESS,"
  .DB_NAME.".ROLE WHERE ".DB_NAME.".APP_ACCESS.App_Id='"
  .$_SESSION['app_id']."' AND ".DB_NAME.".APP_ACCESS.User_Id="
  .$_SESSION['user_id']." AND ".DB_NAME.".APP_ACCESS.App_Id = "
  .DB_NAME.".APP.App_Id AND ".DB_NAME.".APP_ACCESS.Role_Id = "
  .DB_NAME.".ROLE.Role_Id";


//  
//syslog(LOG_DEBUG,$sql_query);

$rapps = $db->db_query($sql_query);
$rapp = $db->db_fetch_object($rapps);

$_SESSION['app_id'] = $rapp->App_Id;
$_SESSION['app_name'] = $rapp->App_Name;
$_SESSION['role_id']= $rapp->Role_Id;
$_SESSION['role_name'] = $rapp->Role_Name;
$_SESSION['database']=$rapp->Db;
$_SESSION['host'] = $rapp->Host;
$_SESSION['current_db'] = $rapp->Db;


//echo '***'.$_SESSION['current_db'].'***' ;


$modules = array();
$mods = $db->db_query("SELECT MODULE.Module_Id,MODULE.Nom,MODULE.Lien"
                      ." FROM MODULE_ACCESS,MODULE WHERE MODULE_ACCESS.User_Id='"
                      .$_SESSION['user_id']
                      ."' AND  MODULE.App_Id='"
                      .$_SESSION['app_id']."' AND MODULE_ACCESS.Module_Id=MODULE.Module_Id AND MODULE.Etat=1");



while($mod = $db->db_fetch_object($mods))
  {
    $tmp = ucfirst(strtolower($mod->Nom));
    array_push($modules,array('nom'=>$tmp,'lien'=>$mod->Module_Id));
  }
  
  
$smarty->assign('css',MINICLICK_HOST_URL.'css/default.css');

$smarty->assign('title',$_SESSION['app_name']);
$smarty->assign('applications',$_SESSION['auth_apps']);
$smarty->assign('modules',$modules);
$smarty->assign('role_name',$_SESSION['role_name']);

$msociete = $db->db_query("SELECT REGROUPE.Societe_Id,SOCIETE.Code,"
                          ." REGROUPE.User_Id FROM REGROUPE,SOCIETE "
                          ."WHERE SOCIETE.Societe_Id = REGROUPE.Societe_Id AND User_Id = '"
                          .$_SESSION['user_id']."'");
$societes_id = array();
$societes_name = array();

while($msoc = $db->db_fetch_object($msociete))
  {
    if( $_SESSION['societe']==""  )
      {
        $_SESSION['societe_id'] = $msoc->Societe_Id;
        $_SESSION['societe'] = $msoc->Code;
      }
    array_push($societes_id,$msoc->Societe_Id);
    array_push($societes_name,$msoc->Code);
  }
  
  
$smarty->assign('societe',$_SESSION['societe_id']);
$smarty->assign('societes_id',$societes_id);
$smarty->assign('societes_name',$societes_name);

if($_GET['where'] != "")
  {
    $_GET['where'] = str_replace("SELECT","",$_GET['where']);
    $_GET['where'] = str_replace("WHERE","",$_GET['where']);
    $_GET['where'] = str_replace("FROM","",$_GET['where']);
    $_GET['where'] = str_replace(";","",$_GET['where']);
    $_GET['where'] = str_replace("EXEC","",$_GET['where']);
  }

$GLOBALS['main'] = 1;

// Vrifier les droits pour le module
if(is_numeric($_GET['module_id']))
	{
	$mods = $db->db_query("SELECT User_Id FROM MODULE_ACCESS WHERE User_Id=".$_SESSION['user_id']." AND Module_Id=".$_GET['module_id']) ;	
	if(mysql_num_rows($mods)==0)
		{			
		$_GET['module_id']='';
		}
	}


if($_GET['module_id'] != "")
  {
    if($_GET['page'] == "")
      {
        $req="SELECT Lien,Etat FROM MODULE WHERE App_Id='"
                              .$_SESSION['app_id']."' AND Module_Id='"
                              .$_GET['module_id']."' LIMIT 1";
                              
        //print $req; print $_SESSION['current_db'];
        
        $mods = $db->db_query($req);

        $mod = $db->db_fetch_object($mods);
        $lien = strtolower($mod->Lien);
        if($mod->Etat == 0)
          {
            $smarty->assign('page','templates/maintenance.tpl');
          }
        else
          {
            $smarty->assign('module_id',$_GET['module_id']);
            $pathToFile='apps/'.$_SESSION['app_name']."/modules/".$lien ;
            if(!file_exists($pathToFile)) {
            	$pathToFile='templates/maintenance.tpl' ;
            }
            $smarty->assign('page',$pathToFile);
          }
      }
    else
      {

        $smarty->assign('module_id',$_GET['module_id']);
        $smarty->assign('page',$_GET['page']);
      }
  }
 else
   {
   	$pathToDefaultFile = 'apps/'.$_SESSION['app_name']."/".'default.php' ;
   	
	if (!file_exists($pathToDefaultFile)) {
		$pathToDefaultFile = 'apps/default.php' ;
	}
		
     $smarty->assign('page',$pathToDefaultFile) ;
   }

   
   
   
//Chargement du fichier de configuration de l'application
if(file_exists(MINICLICK_INSTALL_PATH.'apps/'.$_SESSION['app_name'].'/app_config.php'))
  {
    include(MINICLICK_INSTALL_PATH.'apps/'.$_SESSION['app_name'].'/app_config.php');
  }

//$smarty->display('main.tpl');

$output = $smarty->fetch($smarty->template_dir.'fiche.tpl');
//$output = str_replace(".php?",".php?application=".$_SESSION['app_id']."&amp;",$output);
echo $output;

$db->db_close();
?>
