/* Copyright (C) 2012 Rudra Banerjee*/

/*
This file is part of mkbib.

mkbib is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mkbib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mkbib.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>
#include <string.h>
#include <libsoup/soup.h>
#include "main.h"

void search_gs(GtkWidget *widget, gpointer data) {
  const gchar *strAuth, *strTitle, *strYear;
  gchar *encoded, strurl[1024];
    Entries *e = (Entries*) data;
  strAuth = gtk_entry_get_text(GTK_ENTRY(e->entryAuth));
  strTitle = gtk_entry_get_text(GTK_ENTRY(e->entryTitle));
  strYear = gtk_entry_get_text(GTK_ENTRY(e->entryYear));

  if ((strlen(strTitle)!=0)&(strlen(strAuth)!=0)){
  encoded = soup_form_encode ("as_q", strTitle,
      "as_sauthors", strAuth,
      "as_ylo", strYear, NULL);
  }
  else if((strlen(strTitle)==0)&(strlen(strAuth)!=0)){
    encoded=soup_form_encode("as_q",strAuth,
        "as_ylo",strYear,NULL);
  }
  else if((strlen(strTitle)!=0)&(strlen(strAuth)==0)){
    encoded=soup_form_encode("as_q",strTitle,
        "as_ylo",strYear,NULL);
  }
  else if((strlen(strTitle)==0)&(strlen(strAuth)==0)){
    caution("You haven't given any search criteria!");
    return;
  }
  strcpy(strurl,"http://scholar.google.com/scholar?");
  strcat(strurl,encoded);

  gtk_show_uri(gdk_screen_get_default(),strurl,GDK_CURRENT_TIME,NULL);
}


