#!/usr/bin/env bash
if [[ ${1#lib} == $1 ]]
	then LIBNAME=lib${1}
	else LIBNAME=$1
fi
TRLIBNAME=$(printf $LIBNAME | tr - _)
cat > $1/src/Makefile.am <<EOF
lib_LTLIBRARIES = ${LIBNAME}.la
include_headers = lib.h g-hello-world.h

${TRLIBNAME}_la_SOURCES = g-hello-world.h g-hello-world-private.h g-hello-world.c g-hello-world.gob \\
			  \$(BUILT_SOURCES)
${TRLIBNAME}_la_CPPFLAGS = -I. \$(DEPS_CFLAGS)
${TRLIBNAME}_la_LIBADD = \$(DEPS_LIBS)

BUILT_SOURCES = g-hello-world.gob.stamp

MAINTAINERCLEANFILES = \$(BUILT_SOURCES)

%.gob.stamp: %.gob
	@GOB2@ --no-touch $<
	@touch \$@


%.c %.h %-private.h: %.gob
	@GOB2@ $<
EOF
