# Copyright (C) 2007 Juan Manuel Borges Caño

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

MP_PROJECTDIR="$MP_DATADIR/$1/project"


# mp util functions

function mp_join
{
	STRING="$1"
	shift
	while [[ $# -ne 0 ]]
	do
		if [[ -n $1 ]]
		then STRING+=" $1"
		fi
		shift
	done
	echo "$STRING"
}

# mp functions

function mp_mkdir
{
	if [[ -a $1 ]]
	then
		mp_error "$(basename $1): file exists"
	else
		printf "Creating directory \`$(basename "$1")'..."
			mkdir "$1" 2>> "$MP_ERROR_LOG"
		mp_check_and_echo "$MP_ERROR_LOG"
	fi
}

function mp_source 
{
	if [[ -a $2/$1 ]]
	then
		mp_error "$1: file exists"
	else
		printf "Creating \`$1'..."
			source "$MP_PROJECTDIR/$1.sh" "$2" "$3" "$4" "$5" 2>> "$MP_ERROR_LOG"
		mp_check_and_echo "$MP_ERROR_LOG"
	fi
}

function mp_source_as
{
	if [[ -a $3/$1 ]]
	then
		mp_error "$1: file exists"
	else
		printf "Creating \`$1'..."
			source "$MP_PROJECTDIR/$2.sh" "$3" "$4" "$5" "$6" 2>> "$MP_ERROR_LOG"
		mp_check_and_echo "$MP_ERROR_LOG"
	fi
}

function mp_cp
{
	if [[ -a $2/$1 ]]
	then
		mp_error "$1: file exists"
	else
		printf "Creating \`$1'..."
			cp "$MP_PROJECTDIR/$1" "$2/$1" 2>> "$MP_ERROR_LOG"
		mp_check_and_echo "$MP_ERROR_LOG"
	fi
}

function mp_exec
{
	printf "Executing \`$1' for you (see \`$MP.log')..."
		cd "$2" &&
		echo "$1:" >> "$MP.log" &&
		$1 >> "$MP.log" 2>&1 &&
		cd ..
	mp_check_and_echo
}
