/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_evenement.h"

#ifndef MEMORY_DEBUG
#include <SDL/SDL.h>
#else
#include "memory_debug.h"
#endif

#include <string.h>

#include "warning_error.h"

#include "memory_management.h"

MLV_Event MLV_get_event( 
	int* key_sym, int* key_mod, 
	char** texte, MLV_Prompt** prompt,
	int* mouse_x, int* mouse_y, int* mouse_button,
	int* state
){
	SDL_Event event;
	int invalidEvent = 1;
	while( invalidEvent ){
		if( SDL_PollEvent( &event ) ){
			switch( event.type ){
				case SDL_KEYDOWN: {
					if( key_sym || key_mod || state ){
						if( key_sym ){
							(*key_sym) = event.key.keysym.sym;
						}
						if( key_mod ){
							(*key_mod) = event.key.keysym.mod;
						}
						if( state ){
							(*state) = MLV_PRESSED;
						}
						return MLV_KEY;
					}
				};
				break;
				case SDL_KEYUP:{
					if( key_sym || key_mod || state ){
						if( key_sym ){
							(*key_sym) = event.key.keysym.sym;
						}
						if( key_mod ){
							(*key_mod) = event.key.keysym.mod;
						}
						if( state ){
							(*state) = MLV_RELEASED;
						}
						return MLV_KEY;
					}
				};
				break;
				case SDL_MOUSEMOTION:{
					if( mouse_x || mouse_y ){
						if( mouse_x ){
							(*mouse_x) = event.motion.x;
						}
						if( mouse_y ){
							(*mouse_y) = event.motion.y;
						}
						return MLV_MOUSE_MOTION;
					}
				}
				break;
				case SDL_MOUSEBUTTONUP: {
					if(  mouse_x || mouse_y || mouse_button  || state ){
						if( mouse_x ){
							(*mouse_x) = event.button.x;
						}
						if( mouse_y ){
							(*mouse_y) = event.button.y;
						}
						if( mouse_button ){
							(*mouse_button) = event.button.button;
						}
						if( state ){
							(*state) = MLV_RELEASED;
						}
						return MLV_MOUSE_BUTTON;
					}
				}
				break;
				case SDL_MOUSEBUTTONDOWN: {
					if(  mouse_x || mouse_y || mouse_button  || state ){
						if( mouse_x ){
							(*mouse_x) = event.button.x;
						}
						if( mouse_y ){
							(*mouse_y) = event.button.y;
						}
						if( mouse_button ){
							(*mouse_button) = event.button.button;
						}
						if( state ){
							(*state) = MLV_PRESSED;
						}
						return MLV_MOUSE_BUTTON;
					}
				}
				break;
				case SDL_QUIT:{
				}
				break;
				case SDL_USEREVENT: {
					if( event.user.code == MLV_PROMPT ){
						if( texte || prompt ){
							if( prompt ){
								(*prompt) = event.user.data1;
							}
							if( texte ){
								int size = strlen(event.user.data2)+1;
								(*texte) = MLV_MALLOC( size, char );
								memcpy(
									(*texte), 
									event.user.data2,
									size
								);
							}
							return MLV_PROMPT;
						}
					}
                }
            	break;

				default:;
			}
		}else{
			invalidEvent = 0;
		}
	}
	return MLV_NONE;
}
