/**
 * Ce programme montre comment il est possible d'utiliser et d'afficher des
 * images au format BMP.
 *
 * Pour cela, il suffit d'utiliser les fonctions suivantes :
 * 
 *------------------------------------------------------------------------------
 * MLV_load_image_bmp : Charge en mémoire une image contenu dans un fichier au 
 *                      format BMP.
 *
 * MLV_Image* MLV_load_image_bmp(
 *    const char*    file_image    Chemin d'accès du fichier au format BMP 
 *                                 contenant l'image.
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_free_image : Libère la mémoire utilisée par l'image
 *
 * void MLV_free_image(
 *    MLV_Image *    image    image à suprimer de la mémoire
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_proportionnal_resize_image : redimensionne l'image de telle sorte que les
 *                                  proportions d'origines soient respctées et 
 *                                  que la hauteur et la largeur de la nouvelle
 *                                  image soient à la fois maximales et à la 
 *                                  fois inférieures ou égales à la hauteur et 
 *                                  la largeur données en paramètres.
 *
 *                                  L'utilisateur peut entrer un entier négatif
 *                                  pour les champs width et height. Ces champs 
 *                                  ne sont alors pas pris en compte dans le 
 *                                  redimensionnement de l'image.
 *                                    
 * void MLV_proportionnal_resize_image(
 *    MLV_Image*    image,    image à redimentionner
 *    int           width,    Nouvelle largeur de l'image
 *    int           height    Nouvelle hauteur de l'image
 * );
 *
 *------------------------------------------------------------------------------
 *
 * Il existe de nombreuses fonctions permettant de manipuler les images.
 * Vous trouverez les proptotyes de ces fonctions dans le fichier
 * MLV_image.h.
 *
 * Vous pouvez aussi accéder à ces prototypes et à la documentation de ces
 * fonctions en tapant sur le terminal la commande :
 *     man MLV_image.h
 *
 */

#include "MLV_all.h"

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[] ){
	int width = 640, height = 480;
	MLV_Image* image;

	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", width, height );

	//
	// Lit un fichier au format bmp et charge l'image contenu dans le
	// fichier en mémoire.
	//
	image = MLV_load_image_bmp( "upe_mlv.bmp" );

	//
	// Redimensionne l'image de sorte à ce qu'elle garde sa
	// proportion d'origine et qu'elle rentre dans un rectangle de taille
	// 300 X 300.
	//
	MLV_proportionnal_resize_image( image, 300, 300);

	//
	// Affiche l'image
	//
	MLV_draw_image( image, 0, 0 );

	//
	// Met à jour l'affichage
	//
	MLV_actualise_window();

	//
	// Attend 2 secondes
	//
	MLV_wait_seconds( 2 );

	//
	// Libère l'image qui a été crée
	//
	MLV_free_image( image );

	//
	// Ferme la fenêtre
	//
	MLV_close_window();
	return 0;
}
