/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_color.h"

#include "memory_management.h"

/******************************************************************************/
/* RGBA : Converti une couleur RGBA encodee à l'aide de 4 entiers 8 bits en   */
/*                  en une couleur encodee a l'aide d'1 entier 16 bits.       */
/*                                                                            */
/*                  Dans la librairie SDL_GFX les couleurs sont encodées sur  */
/*                  32 bits : 8 bits pour la composante en rouge de           */
/*                  l'image (R), 8 bits pour la composante verte (G), 8 bit   */
/*                  pour la composante bleu (B) et enfin 8 bits pour la       */
/*                  composante alpha qui correspond a la transparence (A)     */
/*                                                                            */
/* Uint32                                 Couleur codee sur un entier 32 bits */
/* rgba (                                                                     */
/*    Uint8 red,                    Composante rouge de la couleur            */
/*    Uint8 greene,                 Composante verte de la couleur            */
/*    Uint8 blue,                   Composante bleu de la couleur             */
/*    Uint8 alpha)                  Transparence de la couleur                */
/******************************************************************************/
Uint32 MLV_rgba(
    Uint8 red,
    Uint8 green,
    Uint8 blue,
    Uint8 alpha
){
    return (((((( (Uint32) red) << 8) + green) << 8) + blue) << 8) + alpha;
}

