/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __DATA_STRUCTURE__H_
#define __DATA_STRUCTURE__H_

#ifndef MEMORY_DEBUG
#include <SDL/SDL.h>
#else
#include "memory_management.h"
#endif

#include <glib.h>

#include "MLV_playlist.h"
#include "MLV_text.h"

typedef struct _DataMLV {
	SDL_Surface *screen;
	int width;
	int height;
	SDL_Rect rectangle;
	SDL_Surface *save_screen;
	SDL_sem* audio_semaphore;
	SDL_AudioSpec audio_device_spec;
	GList* playing_streaming;
	GList* playlists;
	GList* active_playlists;
	MLV_Font* defaultFont;
} DataMLV;

#endif
