/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_mouse.h"
#include "MLV_evenement.h"

#ifndef MEMORY_DEBUG
#include <SDL/SDL.h>
#else
#include "memory_debug.h"
#endif

#include "warning_error.h"

#include "memory_management.h"

void MLV_mouse_wait(int *x, int *y){
	int state;
	int mouse_button;

	// We remove all existing event from the queue
	MLV_flush_event_queue();

	//We wait for a new mouse event
	while(
		(
			MLV_wait_event(
					NULL, NULL,
					NULL, NULL,
					x, y, &mouse_button,
					&state
			) != MLV_MOUSE_BUTTON
		) ||
		( mouse_button != MLV_BUTTON_LEFT ) ||
		( state != MLV_PRESSED )
	);
};

