/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __WARNING_ERROR_H__
#define __WARNING_ERROR_H__

#include <stdio.h>
#include <stdlib.h>

#define ERROR(x) { fprintf( stderr, "Error detected by the function %s() in LibMLV : %s \n", __FUNCTION__, (x) ); exit(0); }

#define WARNING(x) { fprintf( stderr, "Warning generated by the function %s() in LibMLV : %s \n", __FUNCTION__, (x) ); }

#define TODO { fprintf( stderr, "The function %s() in LibThis Library is not implemented. \n", __FUNCTION__ ); exit(0); }


#define ERROR_FULL(x) { fprintf( stderr, "Error detected by the function %s() in LibMLV : %s ( fichier : %s, ligne : %i) \n", __FUNCTION__, (x), __FILE__, __LINE__ ); exit(0); }

#define WARNING_FULL(x) { fprintf( stderr, "Warning generated by the function %s() in LibMLV : %s ( fichier : %s, ligne : %i) \n", __FUNCTION__, (x), __FILE__, __LINE__ ); }

#define DEBUG(x) { fprintf( stderr, "DEBUG : %s - line : %i, file : %s\n", (x), __LINE__, __FILE__ ); }

#endif
