# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008, 2009 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import gtk

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief 32x32 PNG icon
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ICON_DATA = '''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'''

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Extension class
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Extension (object):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, mediator):
    self.id = 'gtk_ui'
    self.name = 'GTK User Interface'
    self.author = 'Eduardo Aguiar'
    self.version = '0.1.0'
    self.description = 'GTK User Interface'
    self.mediator = mediator.new_client_mediator ()
    self.icon_data = ICON_DATA

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Start extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def start (self):
    self.mediator.advertise ('ui.stop', self.svc_stop)
    self.mediator.advertise ('ui.flush', self.svc_flush)
    self.mediator.advertise ('ui.render-icon', self.svc_render_icon)
    self.mediator.advertise ('ui.new-window', self.svc_new_window)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Stop extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def stop (self):
    self.mediator.clear ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief service: ui.stop
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def svc_stop (self):
    gtk.main_quit ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief service: ui.flush
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def svc_flush (self):
    while gtk.events_pending ():
      gtk.main_iteration ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief service: ui.render-icon
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def svc_render_icon (self, data, width=-1, height=-1):
    loader = gtk.gdk.PixbufLoader ()

    if width != -1:
      loader.set_size (width, height)

    loader.write (data.decode ('base64'))
    loader.close ()
    return loader.get_pixbuf ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief service: ui.new-window
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def svc_new_window (self, title=None):
    window = gtk.Window ()

    if title:
      window.set_title (title)

    return window
