/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <mobius/unittest.h>
#include <mobius/application.h>
#include <cstring>

void
unittest_application ()
{
  mobius::unittest test ("mobius::application");
  mobius::application& app = mobius::get_application ();
  mobius::application& app2 = mobius::get_application ();

  // constants
  test.ASSERT_TRUE (strcmp (app.name, "Mobius Forensic Toolkit") == 0);
  test.ASSERT_TRUE (strlen (app.version) > 0);
  test.ASSERT_TRUE (strlen (app.title) > 0);
  test.ASSERT_TRUE (strlen (app.copyright) > 0);
  test.ASSERT_TRUE (strlen (app.datadir) > 0);

  // unique referenc3
  test.ASSERT_EQUAL (app.name, app2.name);
  test.ASSERT_EQUAL (app.version, app2.version);
  test.ASSERT_EQUAL (app.title, app2.title);
  test.end ();
}
