#ifndef __MOBIUS_TSK_ENTRY_H__
#define __MOBIUS_TSK_ENTRY_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/ref_counter.h>
#include <mobius/tsk/tsk.h>
#include <mobius/tsk/stream.h>
#include <string>
#include <vector>
#include <iterator>

// must include tsk because it declares TSK_FS_DIR as a typedef for type
// TSK_FS_DIR and we cannot do a forward declaration
#include <tsk/libtsk.h>

namespace mobius
{
namespace tsk
{

class entry;

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief collection of filesystem entries
//!\author Eduardo Aguiar
//!\deprecated should be an iterator for entry class
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class entry_list
{
    TSK_FS_DIR *fs_dir_p_;
    mobius::ref_counter counter_;
    std::string path_;

public:
    entry_list (TSK_FS_DIR *, const std::string&);
    ~entry_list ();
    std::size_t get_length () const;
    const entry operator[](std::size_t) const;
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem entry
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class entry
{
    TSK_FS_FILE *fs_file_p_;
    mobius::ref_counter counter_;
    inode_t inode_;
    int type_;
    bool is_deleted_;
    bool is_reallocated_;
    offset_t size_;
    std::string name_;
    std::string short_name_;
    std::string path_;
    int mode_;
    int uid_;
    int gid_;
    std::string atime_;
    std::string mtime_;
    std::string ctime_;
    std::string crtime_;
    std::string dtime_;
    std::vector <stream> streams_;

public:
    entry (TSK_FS_FILE *);
    ~entry ();
    bool is_deleted () const;
    bool is_reallocated () const;
    bool is_folder () const;
    TSK_FS_FILE *get_pointer ();
    inode_t get_inode () const;
    int get_type () const;
    offset_t get_size () const;
    int get_mode () const;
    int get_uid () const;
    int get_gid () const;
    const std::string get_name () const;
    const std::string get_short_name () const;
    const std::string get_atime () const;
    const std::string get_mtime () const;
    const std::string get_ctime () const;
    const std::string get_crtime () const;
    const std::string get_dtime () const;
    const entry_list get_children () const;

    std::size_t get_stream_count () const;
    const stream get_stream_by_idx (std::size_t) const;
    const stream get_stream_by_type (int) const;

    const std::string get_path () const;
    void set_path (const std::string&);

private:
    void __read_fs_name ();
    void __read_fs_meta ();
    void __read_fs_attr ();
};

} // namespace tsk
} // namespace mobius

#endif