#ifndef __MOBIUS_STRING_H__
#define __MOBIUS_STRING_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <string>
#include <vector>

namespace mobius
{
namespace string
{

const std::string replace (const std::string&, const std::string&, const std::string&);
const std::string tolower (const std::string&);
const std::string toupper (const std::string&);
const std::string lstrip (const std::string&, const std::string& = " \t\r\n");
const std::string rstrip (const std::string&, const std::string& = " \t\r\n");
const std::string strip (const std::string&, const std::string& = " \t\r\n");
const std::vector <std::string> split (const std::string&, const std::string& = " ");
const std::string remove_char (const std::string&, char);

bool startswith (const std::string&, const std::string&);
bool endswith (const std::string&, const std::string&);

} // namespace string

        
} // namespace mobius


#endif
