#ifndef __MOBIUS_IO_RESOURCE_IMPL_LOCAL_H__
#define __MOBIUS_IO_RESOURCE_IMPL_LOCAL_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/io/resource_impl_base.h>

namespace mobius
{
namespace io
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief local filesystem resources
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class resource_impl_local : public resource_impl_base
{
public:
  explicit resource_impl_local (const std::string&);
  resource_impl_local (const resource_impl_local&) = default;
  resource_impl_local (resource_impl_local&&) = default;
  resource_impl_local& operator=(const resource_impl_local&) = default;
  resource_impl_local& operator=(resource_impl_local&&) = default;

  virtual bool exists () const override;
  virtual bool is_file () const override;
  virtual bool is_folder () const override;
  virtual size_type get_size () const override;
  virtual user_id_type get_user_id () const override;
  virtual const std::string get_user_name () const override;
  virtual group_id_type get_group_id () const override;
  virtual const std::string get_group_name () const override;
  virtual permission_type get_permissions () const override;
  virtual const mobius::datetime::datetime get_last_access_time () const override;
  virtual const mobius::datetime::datetime get_last_modification_time () const override;
  virtual const mobius::datetime::datetime get_last_metadata_time () const override;

private:
  mutable bool is_stat_loaded_ = false;
  std::string path_;
  mutable bool exists_;
  mutable bool is_file_;
  mutable bool is_folder_;
  mutable size_type size_;
  mutable user_id_type user_id_;
  mutable std::string user_name_;
  mutable group_id_type group_id_;
  mutable std::string group_name_;
  mutable permission_type permissions_;
  mutable mobius::datetime::datetime last_access_time_;
  mutable mobius::datetime::datetime last_modification_time_;
  mutable mobius::datetime::datetime last_metadata_time_;

private:
  void _load_stat () const;
};

} // namespace io
} // namespace mobius

#endif
