#ifndef __MOBIUS_DECODER_MFC_DECODER_H__
#define __MOBIUS_DECODER_MFC_DECODER_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/decoder/data_decoder.h>
#include <mobius/io/file.h>
#include <mobius/datetime/datetime.h>
#include <mobius/bytearray.h>

namespace mobius
{
namespace decoder
{
class mfc_decoder
{
public:
  mfc_decoder (mobius::io::reader);

  bool get_bool ();
  std::uint16_t get_word ();
  std::uint32_t get_dword ();
  std::uint64_t get_qword ();
  std::int32_t get_int ();
  std::uint32_t get_count ();
  const std::string get_string ();
  const std::string get_guid ();
  const std::string get_hex_string (size_t);
  const std::string get_ipv4 ();
  const mobius::bytearray get_data (size_t);
  const mobius::datetime::datetime get_ctime ();
  const mobius::datetime::datetime get_nt_time ();

private:
  mobius::decoder::data_decoder decoder_;
};

} // namespace decoder
} // namespace mobius

#endif
