// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/unittest.h>
#include <mobius/pod/data.h>
#include <mobius/pod/list.h>
#include <mobius/pod/map.h>

void
unittest_pod ()
{
  mobius::unittest test ("mobius::pod");

  // create objects
  mobius::pod::list v;
  v.append (mobius::pod::data ());
  v.append ("abc");
  v.append (std::string ("xyz"));
  v.append (.52);
  v.append (5000000000);
  v.append (-500);
  v.append (false);
  v.append (true);
  v.append (mobius::bytearray { 0x05, 0x28, 0x41, 0x45 });
  v.append (mobius::datetime::datetime (2008, 1, 1, 12, 45, 56));
  v.append (mobius::pod::map {{"zbc",mobius::pod::data ()}, {"a123", true}, {"a23", 5}});
  v.append ({ true, mobius::pod::data (), 500.5, "abc", {1.5, false, 18} });
  
  mobius::pod::list l (v[11]);
  l.append ("xxx");
  l.append (mobius::datetime::datetime (2020, 1, 1, 1, 25, 30));
  
  // test data
  test.ASSERT_EQUAL (v[0], mobius::pod::data ());
  test.ASSERT_EQUAL (v[1], "abc");
  test.ASSERT_EQUAL (v[2], "xyz");
  test.ASSERT_EQUAL (v[3], .52);
  test.ASSERT_EQUAL (v[4], 5000000000);
  test.ASSERT_EQUAL (v[5], -500);
  test.ASSERT_EQUAL (v[6], false);
  test.ASSERT_EQUAL (v[7], true);
  test.ASSERT_EQUAL (v[8], (mobius::bytearray {0x05, 0x28, 0x41, 0x45}));
  test.ASSERT_EQUAL (v[9], mobius::datetime::datetime (2008, 1, 1, 12, 45, 56));
  
  test.ASSERT_TRUE (v[0].is_null ());
  test.ASSERT_TRUE (v[1].is_string ());
  test.ASSERT_TRUE (v[2].is_string ());
  test.ASSERT_TRUE (v[3].is_float ());
  test.ASSERT_TRUE (v[4].is_integer ());
  test.ASSERT_TRUE (v[5].is_integer ());
  test.ASSERT_TRUE (v[6].is_bool ());
  test.ASSERT_TRUE (v[7].is_bool ());
  test.ASSERT_TRUE (v[8].is_bytearray ());
  test.ASSERT_TRUE (v[9].is_datetime ());
  test.ASSERT_TRUE (v[10].is_map ());
  test.ASSERT_TRUE (v[11].is_list ());

  // serialize/unserialize  
  auto data = mobius::pod::serialize (v);
  mobius::pod::list v2 (mobius::pod::unserialize (data));
  
  test.ASSERT_EQUAL (v2[0], mobius::pod::data ());
  test.ASSERT_EQUAL (v2[1], "abc");
  test.ASSERT_EQUAL (v2[2], "xyz");
  test.ASSERT_TRUE (static_cast <long double> (v2[3]) - .52 < .00001);
  test.ASSERT_EQUAL (v2[4], 5000000000);
  test.ASSERT_EQUAL (v2[5], -500);
  test.ASSERT_EQUAL (v2[6], false);
  test.ASSERT_EQUAL (v2[7], true);
  test.ASSERT_EQUAL (v2[8], (mobius::bytearray {0x05, 0x28, 0x41, 0x45}));
  test.ASSERT_EQUAL (v2[9], mobius::datetime::datetime (2008, 1, 1, 12, 45, 56));
  test.ASSERT_EQUAL (v2[10], v[10]);
  test.ASSERT_EQUAL (v2[11], v[11]);

  test.end ();
}
