# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import os

import mobius
from gi.repository import GObject
from gi.repository import Gdk
from gi.repository import Gtk


# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief New case dialog
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class NewCaseDialog(Gtk.Dialog):

    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    # @brief build widget
    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    def __init__(self):

        GObject.GObject.__init__(self, title='New Case', modal=True)
        self.add_button(Gtk.STOCK_OK, Gtk.ResponseType.OK)
        self.add_button(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL)
        self.set_position(Gtk.WindowPosition.CENTER)
        self.set_default_size(500, 200)
        self.set_type_hint(Gdk.WindowTypeHint.DIALOG)
        self.set_border_width(5)
        self.case_id = None
        self.case_name = None
        self.case_folder = None

        # grid
        grid = Gtk.Grid.new()
        grid.set_border_width(5)
        grid.set_column_spacing(5)
        grid.set_row_spacing(10)
        grid.show()
        self.vbox.pack_start(grid, True, True, 0)

        label = Gtk.Label.new('Case folder')
        label.set_xalign(1.0)
        label.show()
        grid.attach(label, 0, 0, 1, 1)

        case_repository_folder = mobius.core.get_config('ice.case-repository-folder') or os.getcwd()

        self.__case_folder_button = Gtk.FileChooserButton(title="Select folder")
        self.__case_folder_button.set_hexpand(True)
        self.__case_folder_button.set_action(Gtk.FileChooserAction.SELECT_FOLDER)
        self.__case_folder_button.set_current_folder(case_repository_folder)
        self.__case_folder_button.show()
        grid.attach(self.__case_folder_button, 1, 0, 2, 1)

        label = Gtk.Label.new('ID')
        label.set_xalign(1.0)
        label.show()
        grid.attach(label, 0, 1, 1, 1)

        self.__entry_id = Gtk.Entry()
        self.__entry_id.set_hexpand(True)
        self.__entry_id.set_text("untitled")
        self.__entry_id.show()
        grid.attach(self.__entry_id, 1, 1, 2, 1)

        label = Gtk.Label.new('Name')
        label.set_xalign(1.0)
        label.show()
        grid.attach(label, 0, 2, 1, 1)

        self.__entry_name = Gtk.Entry()
        self.__entry_name.set_text("Untitled Case")
        self.__entry_name.show()
        grid.attach(self.__entry_name, 1, 2, 2, 1)

    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    # @brief Run dialog
    # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    def run(self):
        rc = None

        while not rc:
            rc = Gtk.Dialog.run(self)

            if rc == Gtk.ResponseType.OK:
                self.case_id = self.__entry_id.get_text().strip()
                self.case_name = self.__entry_name.get_text().strip()
                self.case_folder = self.__case_folder_button.get_filename()

                mobius.core.set_config('ice.case-repository-folder', os.path.dirname(self.case_folder))

        return rc
