/*****************************************************************************
 *
 * Copyright (C) 2005 Alex Karev.
 *
 * This file is part of KP modules library.
 * 
 ****** vim: set ts=4 sw=4 et: ***********************************************/
#ifndef _DB_API_
#define _DB_API_

#include <time.h>
#include <db.h>


#define TAG_NAME_LENGTH	32


enum {
	TYPE_FLOAT_TAG,
	TYPE_INTEGER_TAG
} TAG_TYPE;


enum {
	ARCHIVE_TAG_FLAG
} FLAGS;


#define SET_FLOAT_TAG(t,v) 		\
do {					\
	(t)->type = TYPE_FLOAT_TAG;	\
	(t)->val.f = (v);		\
					\
	(t)->last_update = time(NULL);	\
} while (0)


#define SET_INTEGER_TAG(t,v) 		\
do {					\
	(t)->type  = TYPE_INTEGER_TAG;	\
	(t)->val.i = (v);		\
					\
	(t)->last_update = time(NULL);	\
} while (0)



#define GET_FLOAT_VAL(t)	(t)->val.f
#define GET_INTEGER_VAL(t) 	(t)->val.i


typedef struct tag {
	int type;
	int flags;

	union {
		int i;
		float f;
	} val;
	
	time_t last_update;
} Tag;



#define SET_DS(d,m,ch) 		\
do { 				\
	(d)->modid = (m);	\
	(d)->chid  = (ch);	\
} while (0)			\

typedef struct datasource {
	int modid;
	int chid;
} DataSource;



typedef struct kp_dbms {
	DB *tagdb;
	DB *dsdb;
} DBMS;




#ifdef __cplusplus
extern "C" {
#endif

int env_open( DB_ENV **penv , const char *home_dir, int flags);
int env_close(DB_ENV *env, int flags);

int db_get_tag_val(DB_ENV *env, const char *tagname, Tag *t, int flags);
int db_set_tag_val(DB_ENV *env, const char *tagname, Tag *t, int flags);

int db_create_tag_rec(DB_ENV *env, const char *tagname, int type, DataSource *ds);
int db_update_tag_rec(DB_ENV *env, const char *tagname, Tag *t, DataSource *ds);
int db_select_tag_rec(DB_ENV *env, const char *tagname, Tag *t, DataSource *ds);

int db_print_ds_dep(DB_ENV *env, FILE *ostrem);

int db_update_ds(DB_ENV *env, DataSource *ds, Tag *t);


#ifdef __cplusplus
}
#endif


#endif /* _DB_API_ */

