#if DOS
#include <dos.h>
//#include <io.h>

#include <bios.h>
#include <stdio.h>
#include <conio.h>
//#include <fcntl.h>
//#include <sys\stat.h>

//#include <windows.h>
//#include <toolhelp.h>
#define INIT() ;
#else 
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/io.h>
#include <time.h>

#define INIT() { 		        \
	if (iopl(3))		        \
		exit(1);	            \
} while(0)

#endif


#define delay(t) (void) nanosleep( &((struct timespec ) { .tv_sec = 0, .tv_nsec = (t) * 1000L} ), NULL)
#define inportb(port)		    inb((port))
#define inport(port)		    inw((port))
#define outportb(port,value)	outb((value),(port))
#define kbhit()			        getc(stdin)
#define bioskey(nil)		    getc(stdin)
#define getch()			        getc(stdin)

//*****************************************************************
//   18

// 
#define	mav18_stadr	    0x000
#define mav18_cmdadr    0x002
#define mav18_datadr	0x010
#define mav18_rdy	    0x01
#define mav18_dat_num	18


int exit_analog_poll = 0;


/** Added prototypes at 21.09.05 */
static unsigned mav18_data(unsigned port, unsigned data[]);
static unsigned mav18_cmd(unsigned port, char	 cmd, char data[]);
static unsigned mav18_rd(unsigned port, unsigned adr, unsigned char *dat_p);
static unsigned mav18_st_rd(unsigned port);
static unsigned mav18_wr(unsigned port, unsigned adr, unsigned char dat);
static unsigned byte_in(void);
static int printb(int width, long unsigned dat);
static unsigned mav18_st_wr(unsigned port, unsigned char dat);


static int signal_install(void);
static void sig_handler(int sig_num);


void
sig_handler(int sig_num)	
{
    exit_analog_poll = 1;    
}

int 
signal_install(void)
{
    (void) signal(SIGINT, sig_handler);

    return (0);
}

unsigned mav18_data( //read mav data. return mav18 status:
//FFFF - -,  18 
//0FFF - - -    50
//0000 -         0000.
//		      .
//		    -     
unsigned port, //mav 18 baseport
unsigned data[]) { //pointer to array[18] of mav data
unsigned i, st;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if (inportb(port+2)&mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			for (i=0;i<16;data[i++]=0);	//data
			return 0x0fff; //if mav not acessible
		}
	}
	//read status
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	st=inportb(port);		//data
	outportb(port,0xff);
	st=st+(inportb(port)<<8);//data
	inport(port+4);			//end of read

	//reset status
	outportb(port,0x06);    //write enable command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x02);    //write command
	inportb(port);
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0x00);
	inportb(port);			//
	outportb(port,0x00);
	inportb(port);			//
	inport(port+4);        //end of commnad

	//read reset status (check it for zero!)
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	i=inportb(port);		//data
	outportb(port,0xff);
	i|=inportb(port);		//data
	inport(port+4);			//end of read
	if (i) {	//if st!=0
		outportb(port+2,0);
		for (i=0;i<mav18_dat_num;data[i++]=0);	//data
		return 0xffff; 		//if mav absent or fault
	}

	//read data
	outportb(port,0x03);
	inportb(port);			//read command
	outportb(port,mav18_datadr);
	inportb(port);			//address
	for (i=0; i<mav18_dat_num; i++) {
		outportb(port,0xff);
		data[i]=inportb(port);		//low data
		outportb(port,0xff);
		data[i]=data[i]+(inportb(port)<<8);	//data
	}
	inportb(port+4);			//end of read

	outportb(port+2,0);			//free memory

	return st;
}

// ,   
#define	mav18_cali_cmd  0x11 // , 
#define	mav18_cals0_cmd 0x14 //  ,   ()
#define	mav18_cals1_cmd 0x15 //  ,   ()
#define	mav18_rst_cmd  	0x78 // , 
#define	mav18_dac_cmd  	0x33 // ,  (2  0-0FFF)
#define	mav18_burn_cmd 	0x41 //  , 1  (0-/1-)

unsigned mav18_cmd( //execute mav command. return mav18 status:
//FFFF -  18   
//0FFF - - -    50
//00FF - -  -    
unsigned port, //mav 18 baseport
char	 cmd, //command
char	 data[]) { //array[16] of parameters
//data[0] -    . 0,   
//data[1]... - 
unsigned i,j, f, st;

	//write mav command
	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if (inportb(port+2)&mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//write mav command and parameters
	outportb(port,0x06);    //write enable command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x02);    //write command
	inportb(port);
	outportb(port,mav18_cmdadr);
	inportb(port);			//address
	outportb(port,0x35);
	inportb(port);			//command flag
	outportb(port,cmd);
	inportb(port);			//command code
//	if (data[0]!=0)  //if parameters exist
	for (i=1; i<=data[0]; i++) {
		outportb(port,data[i]);
		inportb(port);			//parameters
	}

	inportb(port+4);        //end of command
	outportb(port+2,0);		//end of mav access

	//wait for "command accepted" flag
	for (j=0; j<1000; j++) { //2 sec time-out
		delay(2);
		inport(port+2);
		for (i=0; i<0xffff; i++) {
			if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
			if (i>50000) {
				inport(port+4);				//end of read
				outportb(port+2,0);
				return 0x0fff; //if mav not acessible
			}
		}

		//read status
		outportb(port,0x03);
		inportb(port);				//"read" command
		outportb(port,mav18_stadr);
		inportb(port);				//address
		outportb(port,0xff);
		st=inportb(port);			//low status
		outportb(port,0xff);
		st=st+(inportb(port)<<8);	//high status
		outportb(port,0xff);
		f=inportb(port);			//command flag

		inport(port+4);				//end of read
		outportb(port+2,0);         //end of mav access

		if ((f==0)||(f==0x53)) return st; //if command OK
		if ((f!=0x35)||(st==0xffff)) return 0xffff;	//mav not exist
	} //for

	return 0x00ff; //command time-out
}

// 
//***************************************************************



unsigned mav18_rd( //read mav byte. return mav18 status:
//FFFF - -,  18 
//0FFF - - -    50
unsigned port, //mav 18 baseport
unsigned adr, //mav memory address
unsigned char *dat_p) {  //pointer to mav byte
unsigned i, st;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}
	//read byte
	st=(adr & 0x0100)>>8-3;	//high bit of address
	outportb(port,0x03|st);
	inportb(port);			//"read" command
	outportb(port,adr);
	inportb(port);			//address
	outportb(port,0xff);
	*dat_p=inportb(port);		//data

	inport(port+4);			//end of read
	outportb(port+2,0);		//end of mav access

	return 0;
}


unsigned mav18_st_wr( //write mav memory status. return mav18 status:
//FFFF - -,  18 
//0FFF - - -    50
unsigned port, //mav 18 baseport
unsigned char dat) { //status byte
unsigned i;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//write status
	outportb(port,0x06);    //"write enable" command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x01);
	inportb(port);          //"write status" command
	outportb(port,dat);
	inportb(port);			//status
	inport(port+4);        //end of commnad

	outportb(port+2,0);		//end of mav access

	return 0;
}


unsigned mav18_st_rd( //read mav memory status:
//FFFF - -,  18 
//0FFF - - -    50
//00XX - memory status
unsigned port //mav 18 baseport
) {
unsigned i;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}

	//read status
	outportb(port,0x05);
	inportb(port);          //"read status" command
	outportb(port,0xFF);
	i=inportb(port);		//status
	inport(port+4);        	//end of commnad

	outportb(port+2,0);		//end of mav access

	return i;
}


unsigned mav18_wr( //write mav byte. return mav18 status:
//FFFF - -,  18 
//0FFF - - -    50
unsigned port, //mav 18 baseport
unsigned adr, //mav memory address
unsigned char dat) { //mav byte
unsigned i, st /*, stm */;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if ((inportb(port+2)&0x01)==mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			return 0x0fff; //if mav not acessible
		}
	}


//	stm=mav18_st_rd(port)&0x0C;	//store memory status
//	mav18_st_wr(port,0x00);		//reset memory protection

	//write byte
	outportb(port,0x06);    	//"write enable" command
	inportb(port);
	inport(port+4);        		//end of commnad

	st=(adr & 0x0100)>>8-3;		//high bit of address
	outportb(port,0x02|st);
	inportb(port);          	//"write" command
	outportb(port,adr);
	inportb(port);				//address
	outportb(port,dat);
	inportb(port);				//data
	inport(port+4);         	//end of commnad

//	mav18_st_wr(port,stm);		//set memory protection

	outportb(port+2,0);			//end of mav access

	return 0;
}

unsigned byte_in(void) {  //input 2-digit hex
unsigned char hex[]={"0123456789ABCDEF"};
unsigned char a, sym, i;

	a=bioskey(0)&0xFF; //input char
	printf("%c",a);
	if (a>=0x60) a=a&0x5F;
	for (i=0; i<16; i++) if (a==hex[i]) break;
	if (i>=16) return a<<8;
	sym=i<<4;
	a=bioskey(0)&0xFF; //input char
	printf("%c",a);
	if (a>=0x60) a=a&0x5F;
	for (i=0; i<16; i++) if (a==hex[i]) break;
	if (i>=16) return a<<8;
	sym=sym|i;

	return sym;
}



int printb(int width, long unsigned dat) { //print word binary
char str_dat[49];
int i;

	if (width>48) return -1;

	str_dat[width]=0;
	for (i=width-1; i>=0; i--) {
		if ((dat&0x0001)!=0) str_dat[i]=0x31;
		else str_dat[i]=0x30;
		dat=dat>>1;
	}
	printf(" %s",str_dat);

	return 0;
}




int main(void) {
int i, i0,/* j, */ ch[10], ch1, ma_f;
unsigned type, mode, base,stat,tok, flag, delta, adr;
unsigned char a, data_b[60];
unsigned data[20], data1[20];
long da, da1;
/* added by Sasha */
char cmd;

	INIT();
    
    (void) signal_install(); 
    

	// printf("\n               ***     .1.0 ***\n : ");
    printf("\n               *** ANALOG MODULE INPUT TEST V.1.0 ***\nBase port: ");
	scanf("%x",&base);
	stat=mav18_data(base,data); //check, if card present
	if (stat>=0xFFF) { //something wrong
		if (stat==0xFFF)
		// printf("\n! Time-out ");
            printf("\nError! Module time-out ");
		else if (stat==0xFFFF)
	    //	printf("\n!    ");
            printf("\nError! Module broken or not exist");
	}

	while (1) {
		// printf("\n (1-, 2-, 3-, 4-): ");
        printf("\nTask (1-test, 2-output, 3-command, 4-service): ");

		scanf("%d",&mode);
		i0=0;
		switch (mode) {
		case 1: {
			printf("Output (1-binary, 2-decimal): ");
			scanf("%u",&type);
			if (type!=2) type=1;
			if (type==1) {
			//only 4 channels for binary mode
				// printf("  (4 !): ");
                 printf("Channel numbers (4 channels!): ");
				scanf("%d %d %d %d",&ch[0],&ch[1],&ch[2], &ch[3]);
			} else {
				// printf(" : ");
                printf("Test channel: ");
				scanf("%d",&ch1);
				//printf("  (0-65535): ");
                printf("Test bound (0-65535): ");
				scanf("%u",&delta);
				// printf(" (0-, 1-, 2-): ");
                printf("Output (0-quantum, 1-mA, 2-mV): ");
				scanf("%u",&ma_f);
			}
			stat=mav18_data(base,data); //input data
			for (i=0; i<mav18_dat_num; i++) data1[i]=data[i]; //remember data
			flag=1;

            
            exit_analog_poll = 0;
			while (!exit_analog_poll) {
				
                stat=mav18_data(base,data); //input data
                if (stat&0x0008) {
                
				    if (type==2) {
					    fprintf (stderr, "\nst=%04X ",stat);
    					for (i=1; i<=mav18_dat_num; i++) {
	    					da=data[i-1];
		    				da1=(unsigned) data1[i-1];
			    			data1[i-1]=da;
				    		if ((ch1==0)||(i==ch1)){
					    		if ((da>da1+delta)||
						    		(da1>da+delta)) flag=0;
    						}
	    					switch (ma_f) {
		    				case 1: { //mA
			    				if (i<=16)
				    			    fprintf (stderr, "% 8.4f",(float)(1280)/65535*da/49.9);
					    		else fprintf (stderr,"% 8.2f",(float)(1280)/65535*(int)da);
						    break;}
    						case 0: { //units
	    						if (i<=16) fprintf (stderr, "% 8ld",da);
		    					else fprintf (stderr, "% 8ld",da);
			    			break;}
				    		default: { //mV
					    		if (i<=16)
						    	fprintf (stderr, "% 8.2f",(float)(1280)/65535*da);
							    else fprintf (stderr, "% 8.2f",(float)(1280)/65535*(int)da);
    						}
	   	    				} //switch (ma_f)
	    				} //for(i=1;
			    	} else {
				    	a=0x0d;
					    fprintf (stderr, "%cst=%04X ",a,stat);
    					for (i=0; i<4; i++) printb (16,data[ch[i]-1]);
	    			} // if (type==2)

                } else {
                    fputc('.',stderr);
                }

                
				if ((stat!=0)&&((stat&0x0008)==0)) flag=0;
                   

                if (flag==0) { //wait for key pressed, if data are broken
                    int ch;
                    fputs("Red flag rised: stat != 0 && stat != 0x0008\n", stderr);
                    
                    ch = getc(stdin);
                    if (ch == 'e' || ch == 'E') break;

#if DOS
					while (kbhit()==0) ; //loop while key not pressed
					flag=1;
					a=getch()&0xff;
					if ((a==*"e")||(a==*"E")) break;
#endif
				}

#if DOS
				if (kbhit()!=0) {//if key pressed - get symbol
					a=getch();
					if (a!=*" ") break; //break loop
					a=getch(); //wait for nex key
				}
#endif 

			} //while (1)

			break;
		} //case 1
		case 2: { //output
			cmd=mav18_dac_cmd;
			while (1) {
				// printf(": ");
                printf("Channel: ");

				scanf("%d",&ch1);
				if ((ch1==0)||(ch1>4)) break;
				data_b[0]=3;
				data_b[1]=ch1;	//channel
				// TODO printf("(0-FFF): ");
                printf("tok (0-FFF): ");

				scanf("%x",&tok);
				data_b[2]=tok&0x0ff;
				data_b[3]=(tok>>8)&0x0ff;
				stat=mav18_cmd(base,cmd,data_b);
				printf("  st=%X\n",stat);
			}
			break;
		}
		case 3: { //command
			// printf(" (1-, 2-., 3-.): ");
            printf("command (1-reset, 2-int.tuning, 3-tok.test): ");

			scanf("%d", (int *) &cmd);
			data_b[0]=0; //no (zero) parameters
			switch (cmd) { //parameters request
			case 1: {
				cmd=mav18_rst_cmd;
				break;
			}
			case 2: {
				cmd=mav18_cali_cmd;
				// printf(" ");
                printf("internel tuninig");
				break;
			}
			case 3: { //burnout current
				cmd=mav18_burn_cmd;
				data_b[0]=1;				//1 parameter
				// printf("  (0-, 1-): ");
                printf("Test tok (0-off, 1-on): ");
				scanf("%d",  (int *) &data_b[1]);
				break;
			}
			default: cmd=0;
			} //switch cmd
			if (cmd==0) break;
			stat=mav18_cmd(base,cmd,data_b);
			printf("  st= %X",stat);

			break;
		} //case command
		case 4: { //service
			//printf("       \n");
			//printf(" (1-.0, 2-.1, 3-, 4-, 5- ): ");
			printf("Using of corrent commands can lead to module demage\n");
			printf("command (1-tuning.0, 2-tuning.1, 3-modification, 4-commnad, 5-memory protection): ");
			scanf("%d",  (int *) &cmd);
			data_b[0]=0;
			switch (cmd) { //parameters request
			case 1: {
				cmd=mav18_cals0_cmd;
				// printf(" . k: ");
                printf("Tuning of zero. channal: ");

				data_b[0]=1;
				scanf("%d", (int *) &data_b[1]);
				if ((data_b[1]<1)||(data_b[1]>16)) cmd=0;
				break;
			}
			case 2: {
				cmd=mav18_cals1_cmd;
				// printf(" . k: ");
                printf("tuning of scale. channel: ");

				data_b[0]=1;
				scanf("%d",  (int *) &data_b[1]);
				if ((data_b[1]<1)||(data_b[1]>16)) cmd=0;
				break;
			}
			case 3: { //read and modify
				// printf("/  . : ");
                printf("read/modification of interface memory. address: ");

				scanf("%x",&adr);
				while (1) { //memory read/write loop
					stat=mav18_rd(base, adr, &a); //read byte
					if (stat!=0) { //bad status
						printf("stat=%04X\n",stat); break;
					}
					printf(" %02x-",a);
					stat=byte_in();		//input byte
					if (stat<0x0100) { //normal byte input
						stat=mav18_wr(base, adr, stat);		//write byte
						if (stat!=0) { //bad status
							printf("stat=%04X\n",stat); break;
						}
					} else		//no normal byte
					if ((stat>>8)!=*" ") break;
					adr++;
				} //while 1

				break;
			} //case read
			case 4: { //command
				// printf(" 1 2 3: ");
                printf("command param1 param2 param3: ");

				scanf("%x %x %x %x", (int *) &cmd, (int *) &data_b[1],(int *) &data_b[2],(int *) &data_b[3]);
				data_b[0]=3; //3 parameters
				break;
			}
			case 5: { //command
				cmd=(mav18_st_rd(base)&0x0C)>>2;//protection status
				// printf("  (0-, 1-1/4, 2-1/2, 3-) %1X: ",cmd);
                printf("memory protection (0-off, 1-1/4, 2-1/2, 3-full) %1X: ",cmd);

				scanf("%d",(int *) &cmd);
				cmd=(cmd&0x03)<<2;
				mav18_st_wr(base,cmd);			//set memory protection
			}
			default: cmd=0;
			} //switch cmd

			if ((cmd==0)||(cmd==3)) break;
			stat=mav18_cmd(base,cmd,data_b);
			printf("  st= %0X",stat);

			break;
		} //case service
		default: mode=0;
		} //switch

		if (mode==0) break; //break the loop

	} //while(1) main loop

	return (0);
}

/****** vim: set ts=4 sw=4 et: ***********************************************/

