/*****************************************************************************
 *
 * Copyright (C) 2005 Alex Karev.
 *
 * This file is part of KP modules library.
 * 
 ****** vim: set ts=4 sw=4 et: ***********************************************/
#include <stdint.h>
#include <string.h>
#include <sys/io.h>
#include <errno.h>
#include <time.h>

#include "mod.h"
#include "dbapi.h"


#define MAX_MODULES		8 + 1
#define MAX_DISCRET_CHANNEL	128 + 1


#define MAX_OUT_CHANNEL        24  // 24x8 = 192 bits

//#define DISCRET_BASE		0x100
//#define OUT_BASE        	0x200  //second 220 for Gluhov


static void OutputAsync (void);


static unsigned mav18_data(unsigned port, unsigned data[]);


/*******************************************************************************
 *	II definitions.
 ******************************************************************************/
typedef unsigned short USHORT;
typedef unsigned char  UCHAR;
typedef unsigned long  ULONG;
typedef signed long    LONG;
typedef signed short   SHORT;
typedef char           CHAR;
typedef double         REAL;




#define FALSE   0
#define TRUE    (!FALSE)
#define TIME_SLICE      100L         /* miscellaneous times in milliseconds, */
#define True 			1


uint8_t Discret_1 [MAX_MODULES][MAX_DISCRET_CHANNEL];
uint8_t Discret_2 [MAX_MODULES][MAX_DISCRET_CHANNEL];
uint8_t Discret_3 [MAX_MODULES][MAX_DISCRET_CHANNEL];

uint8_t Module_Discret [MAX_DISCRET_CHANNEL][9];

UCHAR  Module_Out     [MAX_OUT_CHANNEL+1][3] = { {0} }; // reset data,current data, channel
UCHAR  Timer_Out      [MAX_OUT_CHANNEL * 8 + 1]   = {0}; // timers counter for reset for 24 x 8 bits

USHORT DiscretUpdateTimeout = 1;   //default async on,may  change by host
USHORT OutputUpdateTimeout  = 20;  // if  !=0 then  1 sec  now not used

volatile int exit_threads;



/** 
 * Dummy stubs for RTK compatibility
 */
#define _disable() ;
#define _enable() ;

#define IN_BYTE(p)		inb(p)
#define OUT_BYTE(port,val)	outb(val,port)

static int
RTKDelay(long ms) 
{
        struct timespec req, rem;
        int ret, t;
        
        (void) memset(&req, 0, sizeof req);
        (void) memset(&rem, 0, sizeof rem);

        req.tv_sec      = ms / 1000L;

	t 		= ms % 1000L;
        req.tv_nsec     = t ? t * 1000000L : 0;

        do {
                
                if (ret = nanosleep(&req, &rem)) {
                        
                       if (errno == EINTR) {
                              (void) memcpy(&req, &rem, sizeof req );
                              continue;
                       }
                }
                        
                break;

        } while(1);

        return (ret);
}

//discret output driver fot gluchov module 32 DO
//base port =200 or 220,230,240,250,260         7 6 5 4 3 2 1 0
//port =BasePort  + 0, output data 0 - 8  r/w   x x x x x x x x
//port =BasePort  + 1, output data 9 -15  r/w   x x x x x x x x
//port =BasePort  + 2, output data 16-23  r/w   x x x x x x x x
//port =BasePort  + 3, output data 24-31  r/w   x x x x x x x x
//port =BasePort  + 4, control mask ENABLE w    * * * x x x x x  N = 0 -- 31
//port =BasePort  + 5, ENABLE              w    x x x x x x x x
void 
OutputAsync (void)  /* task to transmit ASYNC Output packets to RS 485 net */
{


    USHORT  /* stat, */ j;
    //UCHAR   VaL1;
    UCHAR   Len, i;
    //UCHAR   sec,min,hour,day,month,year;
    //UCHAR   STATUS;
    uint16_t OUT_BASE;

   Len=2;                          // type + 1 data


   while (True) {

                
	   printf ("O");


      if (OutputUpdateTimeout !=0) {    //200 ms


                      for (i=1; i< (MAX_OUT_CHANNEL * 8 + 1); i++) {



                       if (Timer_Out [i] != 0) {    //set from int_handler


                       if (Timer_Out [i] == 1) {    //after 2 sec

//                         printf ("*");

//                    _disable();

                        j=(i-1)/8;   // 0,1,  ... 7,... 23
                        j=j+1;       //1,2 ... 24

                        // get from int_handler reset data

                        Module_Out [j] [1] = Module_Out [j] [0];


                      if (i < 33 ) { // for first module j =1,2,3,4
                        OUT_BYTE (OUT_BASE+j-1, 0) ;//data
                        OUT_BYTE (OUT_BASE+4, i-1) ;  //mask
                        OUT_BYTE (OUT_BASE+5,0xFF) ; //control       //enable
                      }

                      if ((i > 32) && (i < 65) ) { // for 2 module j =5,6,7,8
                        OUT_BYTE (OUT_BASE+j + 0x20 - 5, 0) ;
                        OUT_BYTE (OUT_BASE+4 + 0x20,     i-33) ;
                        OUT_BYTE (OUT_BASE+5 + 0x20,     0xFF) ; //control
                      }

                      if ((i > 64) && (i < 97) ) { // for 3 module j =9,10,11,12
                        OUT_BYTE (OUT_BASE+j + 0x30 - 9, 0) ;
                        OUT_BYTE (OUT_BASE+4 + 0x30,     i-65) ;
                        OUT_BYTE (OUT_BASE+5 + 0x30,     0xFF) ; //control
                      }


                      if ((i > 96) && (i < 129) ) { // for 4 module j =13,14,15,16
                        OUT_BYTE (OUT_BASE+j + 0x40 - 13, 0) ;
                        OUT_BYTE (OUT_BASE+4 + 0x40,     i-97) ;
                        OUT_BYTE (OUT_BASE+5 + 0x40,     0xFF) ; //control
                      }

                      if ((i > 128) && (i < 161) ) { // for 5 module j =17,18,19,20
                        OUT_BYTE (OUT_BASE+j + 0x50 - 17, 0) ;
                        OUT_BYTE (OUT_BASE+4 + 0x50,     i-129) ;
                        OUT_BYTE (OUT_BASE+5 + 0x50,     0xFF) ; //control
                      }

                      if ((i > 160) && (i < 193) ) { // for 6 module j =21,22,23,24
                        OUT_BYTE (OUT_BASE+j + 0x60 - 21, 0) ;
                        OUT_BYTE (OUT_BASE+4 + 0x60,     i-161) ;
                        OUT_BYTE (OUT_BASE+5 + 0x60,     0xFF) ; //control
                      }

//                    _enable();

        //
        // Send Output packet to Packet buffer and update the
        // data structure.
        // TODO:




                       }    //after 1 sec   if (Timer_Out [i] == 1

                      Timer_Out  [i] = Timer_Out  [i]  -1;     //reset flag

                      } // if channel are used if (Timer_Out [i] != 0

                      } //for i





              RTKDelay(OutputUpdateTimeout*10);
      } else {
	      RTKDelay(1000L);
      }
  }     //while true
}


//discret driver fot gluchov module 32x6
//port =110,111,112,113 - 3 time poll, debonse time 60ms (max 60ms for rele)
//port =120,121,122,123 - 3 time poll, debonse time 60ms (max 60ms for rele)
//port =130,131,132,133 - 3 time poll, debonse time 60ms (max 60ms for rele)

//port =140,141,142,143 - 3 time poll, debonse time 60ms (max 60ms for rele)
//port =150,151,152,153 - 3 time poll, debonse time 60ms (max 60ms for rele)
//port =160,161,162,163 - 3 time poll, debonse time 60ms (max 60ms for rele)
void *
DiscretAsync (void *arg)  /* task to  Discret poll */
{
   /*	
   USHORT  stat;
   */
   UCHAR   Old, value, mask, j, i, k/*, l */;
   /*
   UCHAR   sec,min,hour,day,month,year;

   ULONG   mask_30;
   */
   UCHAR   /* STATUS, */ FIRST;
   TaskArg *a = arg;
   DataSource ds;
   Tag tag;
   DB_ENV *env = arg;
   unsigned DISCRET_BASE;

   
   if (NULL == env || NULL == a) return (NULL);


   DISCRET_BASE = a->base;
   FIRST = TRUE;  // first read (initialization)


   for (j=1; j< MAX_DISCRET_CHANNEL + 1; j++) {
   Module_Discret  [j] [0] = 1;     //  enable this group
   Module_Discret  [j] [1] = 0x00;   // for all bits clear
   Module_Discret  [j] [2] = 0x00;   // for all bits clear
   Module_Discret  [j] [3] = 0x00;   // for all bits clear
   Module_Discret  [j] [4] = 0x00;   // for all bits clear
   Module_Discret  [j] [5] = 0xFF;   // only 8 bits enable
   Module_Discret  [j] [6] = 0xFF;   // only 8 bits enable
   Module_Discret  [j] [7] = 0xFF;   // only 8 bits enable
   Module_Discret  [j] [8] = 0xFF;   // only 8 bits enable
   }

   Module_Discret  [1] [1] = (IN_BYTE (DISCRET_BASE)           & Module_Discret [1] [5]);
   Module_Discret  [1] [2] = (IN_BYTE (DISCRET_BASE + 1)       & Module_Discret [1] [6]);
   Module_Discret  [1] [3] = (IN_BYTE (DISCRET_BASE + 2)       & Module_Discret [1] [7]);
   Module_Discret  [1] [4] = (IN_BYTE (DISCRET_BASE + 3)       & Module_Discret [1] [8]);
#if 0
   Module_Discret  [2] [1] = (IN_BYTE (DISCRET_BASE + 0x10)    & Module_Discret [2] [5]);
   Module_Discret  [2] [2] = (IN_BYTE (DISCRET_BASE + 0x11)    & Module_Discret [2] [6]);
   Module_Discret  [2] [3] = (IN_BYTE (DISCRET_BASE + 0x12)    & Module_Discret [2] [7]);
   Module_Discret  [2] [4] = (IN_BYTE (DISCRET_BASE + 0x13)    & Module_Discret [2] [8]);
   Module_Discret  [3] [1] = (IN_BYTE (DISCRET_BASE + 0x20)    & Module_Discret [3] [5]);
   Module_Discret  [3] [2] = (IN_BYTE (DISCRET_BASE + 0x21)    & Module_Discret [3] [6]);
   Module_Discret  [3] [3] = (IN_BYTE (DISCRET_BASE + 0x22)    & Module_Discret [3] [7]);
   Module_Discret  [3] [4] = (IN_BYTE (DISCRET_BASE + 0x23)    & Module_Discret [3] [8]);
   Module_Discret  [4] [1] = (IN_BYTE (DISCRET_BASE + 0x30)    & Module_Discret [4] [5]);
   Module_Discret  [4] [2] = (IN_BYTE (DISCRET_BASE + 0x31)    & Module_Discret [4] [6]);
   Module_Discret  [4] [3] = (IN_BYTE (DISCRET_BASE + 0x32)    & Module_Discret [4] [7]);
   Module_Discret  [4] [4] = (IN_BYTE (DISCRET_BASE + 0x33)    & Module_Discret [4] [8]);
   Module_Discret  [5] [1] = (IN_BYTE (DISCRET_BASE + 0x40)    & Module_Discret [5] [5]);
   Module_Discret  [5] [2] = (IN_BYTE (DISCRET_BASE + 0x41)    & Module_Discret [5] [6]);
   Module_Discret  [5] [3] = (IN_BYTE (DISCRET_BASE + 0x42)    & Module_Discret [5] [7]);
   Module_Discret  [5] [4] = (IN_BYTE (DISCRET_BASE + 0x43)    & Module_Discret [5] [8]);
   Module_Discret  [6] [1] = (IN_BYTE (DISCRET_BASE + 0x50)    & Module_Discret [6] [5]);
   Module_Discret  [6] [2] = (IN_BYTE (DISCRET_BASE + 0x51)    & Module_Discret [6] [6]);
   Module_Discret  [6] [3] = (IN_BYTE (DISCRET_BASE + 0x52)    & Module_Discret [6] [7]);
   Module_Discret  [6] [4] = (IN_BYTE (DISCRET_BASE + 0x53)    & Module_Discret [6] [8]);
#endif

//   Module_Discret_32 = 0x3FFFFFFF;   // 30 first bits cleear
//   Module_Discret_32 = 0x00;   // 30 first bits cleear     now not used


   while (!exit_threads)
   {

//              printf ("D");

      if (DiscretUpdateTimeout !=0) {


//        _disable();
          Discret_1  [1] [1] = (IN_BYTE (DISCRET_BASE)           & Module_Discret [1] [5]);
          Discret_1  [1] [2] = (IN_BYTE (DISCRET_BASE + 1)       & Module_Discret [1] [6]);
          Discret_1  [1] [3] = (IN_BYTE (DISCRET_BASE + 2)       & Module_Discret [1] [7]);
          Discret_1  [1] [4] = (IN_BYTE (DISCRET_BASE + 3)       & Module_Discret [1] [8]);
#if 0
          Discret_1  [2] [1] = (IN_BYTE (DISCRET_BASE + 0x10)    & Module_Discret [2] [5]);
          Discret_1  [2] [2] = (IN_BYTE (DISCRET_BASE + 0x11)    & Module_Discret [2] [6]);
          Discret_1  [2] [3] = (IN_BYTE (DISCRET_BASE + 0x12)    & Module_Discret [2] [7]);
          Discret_1  [2] [4] = (IN_BYTE (DISCRET_BASE + 0x13)    & Module_Discret [2] [8]);
          Discret_1  [3] [1] = (IN_BYTE (DISCRET_BASE + 0x20)    & Module_Discret [3] [5]);
          Discret_1  [3] [2] = (IN_BYTE (DISCRET_BASE + 0x21)    & Module_Discret [3] [6]);
          Discret_1  [3] [3] = (IN_BYTE (DISCRET_BASE + 0x22)    & Module_Discret [3] [7]);
          Discret_1  [3] [4] = (IN_BYTE (DISCRET_BASE + 0x23)    & Module_Discret [3] [8]);
          Discret_1  [4] [1] = (IN_BYTE (DISCRET_BASE + 0x30)    & Module_Discret [4] [5]);
          Discret_1  [4] [2] = (IN_BYTE (DISCRET_BASE + 0x31)    & Module_Discret [4] [6]);
          Discret_1  [4] [3] = (IN_BYTE (DISCRET_BASE + 0x32)    & Module_Discret [4] [7]);
          Discret_1  [4] [4] = (IN_BYTE (DISCRET_BASE + 0x33)    & Module_Discret [4] [8]);
          Discret_1  [5] [1] = (IN_BYTE (DISCRET_BASE + 0x40)    & Module_Discret [5] [5]);
          Discret_1  [5] [2] = (IN_BYTE (DISCRET_BASE + 0x41)    & Module_Discret [5] [6]);
          Discret_1  [5] [3] = (IN_BYTE (DISCRET_BASE + 0x42)    & Module_Discret [5] [7]);
          Discret_1  [5] [4] = (IN_BYTE (DISCRET_BASE + 0x43)    & Module_Discret [5] [8]);
          Discret_1  [6] [1] = (IN_BYTE (DISCRET_BASE + 0x50)    & Module_Discret [6] [5]);
          Discret_1  [6] [2] = (IN_BYTE (DISCRET_BASE + 0x51)    & Module_Discret [6] [6]);
          Discret_1  [6] [3] = (IN_BYTE (DISCRET_BASE + 0x52)    & Module_Discret [6] [7]);
          Discret_1  [6] [4] = (IN_BYTE (DISCRET_BASE + 0x53)    & Module_Discret [6] [8]);
#endif
//         _enable();

          RTKDelay(60);     //60ms sec wait for stabilization debonse


//        _disable();
          Discret_2  [1] [1] = (IN_BYTE (DISCRET_BASE)           & Module_Discret [1] [5]);
          Discret_2  [1] [2] = (IN_BYTE (DISCRET_BASE + 1)       & Module_Discret [1] [6]);
          Discret_2  [1] [3] = (IN_BYTE (DISCRET_BASE + 2)       & Module_Discret [1] [7]);
          Discret_2  [1] [4] = (IN_BYTE (DISCRET_BASE + 3)       & Module_Discret [1] [8]);
#if 0
          Discret_2  [2] [1] = (IN_BYTE (DISCRET_BASE + 0x10)    & Module_Discret [2] [5]);
          Discret_2  [2] [2] = (IN_BYTE (DISCRET_BASE + 0x11)    & Module_Discret [2] [6]);
          Discret_2  [2] [3] = (IN_BYTE (DISCRET_BASE + 0x12)    & Module_Discret [2] [7]);
          Discret_2  [2] [4] = (IN_BYTE (DISCRET_BASE + 0x13)    & Module_Discret [2] [8]);
          Discret_2  [3] [1] = (IN_BYTE (DISCRET_BASE + 0x20)    & Module_Discret [3] [5]);
          Discret_2  [3] [2] = (IN_BYTE (DISCRET_BASE + 0x21)    & Module_Discret [3] [6]);
          Discret_2  [3] [3] = (IN_BYTE (DISCRET_BASE + 0x22)    & Module_Discret [3] [7]);
          Discret_2  [3] [4] = (IN_BYTE (DISCRET_BASE + 0x23)    & Module_Discret [3] [8]);
          Discret_2  [4] [1] = (IN_BYTE (DISCRET_BASE + 0x30)    & Module_Discret [4] [5]);
          Discret_2  [4] [2] = (IN_BYTE (DISCRET_BASE + 0x31)    & Module_Discret [4] [6]);
          Discret_2  [4] [3] = (IN_BYTE (DISCRET_BASE + 0x32)    & Module_Discret [4] [7]);
          Discret_2  [4] [4] = (IN_BYTE (DISCRET_BASE + 0x33)    & Module_Discret [4] [8]);
          Discret_2  [5] [1] = (IN_BYTE (DISCRET_BASE + 0x40)    & Module_Discret [5] [5]);
          Discret_2  [5] [2] = (IN_BYTE (DISCRET_BASE + 0x41)    & Module_Discret [5] [6]);
          Discret_2  [5] [3] = (IN_BYTE (DISCRET_BASE + 0x42)    & Module_Discret [5] [7]);
          Discret_2  [5] [4] = (IN_BYTE (DISCRET_BASE + 0x43)    & Module_Discret [5] [8]);
          Discret_2  [6] [1] = (IN_BYTE (DISCRET_BASE + 0x50)    & Module_Discret [6] [5]);
          Discret_2  [6] [2] = (IN_BYTE (DISCRET_BASE + 0x51)    & Module_Discret [6] [6]);
          Discret_2  [6] [3] = (IN_BYTE (DISCRET_BASE + 0x52)    & Module_Discret [6] [7]);
          Discret_2  [6] [4] = (IN_BYTE (DISCRET_BASE + 0x53)    & Module_Discret [6] [8]);
#endif
//       _enable();

          RTKDelay(60);     //60ms sec wait for stabilization debonse

//        _disable();
          Discret_3  [1] [1] = (IN_BYTE (DISCRET_BASE)           & Module_Discret [1] [5]);
          Discret_3  [1] [2] = (IN_BYTE (DISCRET_BASE + 1)       & Module_Discret [1] [6]);
          Discret_3  [1] [3] = (IN_BYTE (DISCRET_BASE + 2)       & Module_Discret [1] [7]);
          Discret_3  [1] [4] = (IN_BYTE (DISCRET_BASE + 3)       & Module_Discret [1] [8]);
#if 0
          Discret_3  [2] [1] = (IN_BYTE (DISCRET_BASE + 0x10)    & Module_Discret [2] [5]);
          Discret_3  [2] [2] = (IN_BYTE (DISCRET_BASE + 0x11)    & Module_Discret [2] [6]);
          Discret_3  [2] [3] = (IN_BYTE (DISCRET_BASE + 0x12)    & Module_Discret [2] [7]);
          Discret_3  [2] [4] = (IN_BYTE (DISCRET_BASE + 0x13)    & Module_Discret [2] [8]);
          Discret_3  [3] [1] = (IN_BYTE (DISCRET_BASE + 0x20)    & Module_Discret [3] [5]);
          Discret_3  [3] [2] = (IN_BYTE (DISCRET_BASE + 0x21)    & Module_Discret [3] [6]);
          Discret_3  [3] [3] = (IN_BYTE (DISCRET_BASE + 0x22)    & Module_Discret [3] [7]);
          Discret_3  [3] [4] = (IN_BYTE (DISCRET_BASE + 0x23)    & Module_Discret [3] [8]);
          Discret_3  [4] [1] = (IN_BYTE (DISCRET_BASE + 0x30)    & Module_Discret [4] [5]);
          Discret_3  [4] [2] = (IN_BYTE (DISCRET_BASE + 0x31)    & Module_Discret [4] [6]);
          Discret_3  [4] [3] = (IN_BYTE (DISCRET_BASE + 0x32)    & Module_Discret [4] [7]);
          Discret_3  [4] [4] = (IN_BYTE (DISCRET_BASE + 0x33)    & Module_Discret [4] [8]);
          Discret_3  [5] [1] = (IN_BYTE (DISCRET_BASE + 0x40)    & Module_Discret [5] [5]);
          Discret_3  [5] [2] = (IN_BYTE (DISCRET_BASE + 0x41)    & Module_Discret [5] [6]);
          Discret_3  [5] [3] = (IN_BYTE (DISCRET_BASE + 0x42)    & Module_Discret [5] [7]);
          Discret_3  [5] [4] = (IN_BYTE (DISCRET_BASE + 0x43)    & Module_Discret [5] [8]);
          Discret_3  [6] [1] = (IN_BYTE (DISCRET_BASE + 0x50)    & Module_Discret [6] [5]);
          Discret_3  [6] [2] = (IN_BYTE (DISCRET_BASE + 0x51)    & Module_Discret [6] [6]);
          Discret_3  [6] [3] = (IN_BYTE (DISCRET_BASE + 0x52)    & Module_Discret [6] [7]);
          Discret_3  [6] [4] = (IN_BYTE (DISCRET_BASE + 0x53)    & Module_Discret [6] [8]);
#endif
//       _enable();

#if 0
	  (void) fputs("\n",stderr);
	for(i=1;i<5;i++)
		fprintf(stderr,"Discret_3[%d]: %02x ", i, Discret_3  [1] [i]);
#endif

       for (j=1; j<2; j++) {
        for (k=1; k<5; k++) {
         if ((Discret_1  [j] [k] == Discret_2  [j] [k]) && (Discret_1  [j] [k] == Discret_3  [j] [k])) {
          if (Discret_1  [j] [k] != Module_Discret  [j] [k]) {

          Old = Module_Discret  [j] [k];
          Module_Discret  [j] [k] = Discret_1  [j] [k];



             mask = 1;

             for (i=1; i<9; i++) {         //only first 8 bits


               if ((Old & mask) != (Module_Discret  [j] [k] & mask)) {

                 if ((Old & mask) == 0)  {

                  value = 1;

//                  mask_30 = 1;
//                  for (l=1; l < 15 * (j-1) + 5 * (k-1) + i; l++) mask_30 = mask_30 << 1;  //next bit
//                  Module_Discret_32 = Module_Discret_32 | mask_30;

                 }

                 if ((Old & mask) != 0)  {

                  value = 0;

//                  mask_30 = 1;
//                  for (l=1; l < 15 * (j-1) + 5 * (k-1) + i; l++) mask_30 = mask_30 << 1;  //next bit
//                  Module_Discret_32 = Module_Discret_32 & (~mask_30);

                 }

                  if (FIRST == FALSE) {

			/*
			 *	Value changed, do something usefull.
			 */
#if 0
			SET_DS(&ds,j,k);
			SET_INTEGER_TAG(&tag, value);
			(void) db_update_ds(env, &ds, &tag);
#endif
			fprintf(stderr, "j: %d k: %d val: %d\n", j, k, value);

        //
        // Send Discret packet to Packet buffer and update the
        // data structure.
#if 0
                    OUT_BYTE (CMOS_PORT,CMOS_SECONDS);
                    sec   = IN_BYTE (CMOS_DATA);
                    OUT_BYTE (CMOS_PORT,CMOS_MINUTES);
                    min   = IN_BYTE (CMOS_DATA);
                    OUT_BYTE (CMOS_PORT,CMOS_HOURS);
                    hour  = IN_BYTE (CMOS_DATA);
                    OUT_BYTE (CMOS_PORT,CMOS_DAY);
                    day   = IN_BYTE (CMOS_DATA);
                    OUT_BYTE (CMOS_PORT,CMOS_MONTH);
                    month = IN_BYTE (CMOS_DATA);
                    OUT_BYTE (CMOS_PORT,CMOS_YEAR);
                    year  = IN_BYTE (CMOS_DATA);
#endif
                         // flag for exit to DOS for next TEST
//                       if ((i == 8) && (k==4) && (j==3))  Do_test=Do_test +1;



                        } // if FIRST

                   } // if found bits

                  mask = mask << 1;  //next bit

                 } // for i


               } // if 3 inputs are equal
             } // if new value
           } // for k
         }  // for j

         FIRST = FALSE; // after initialization data
  
	 RTKDelay(DiscretUpdateTimeout*10);
      } else {
	      RTKDelay(1000L);     //1 sec wait
    }
  }     //while true

   return (NULL);
}



//*****************************************************************
//   18

#define delay(t) (void)		nanosleep( &((struct timespec ) { .tv_sec = 0, .tv_nsec = (t) * 1000L} ), NULL)
#define inportb(port)		inb((port))
#define inport(port)		inw((port))
#define outportb(port,value)	outb((value),(port))
#define kbhit()			getc(stdin)
#define bioskey(nil)		getc(stdin)
#define getch()			getc(stdin)


// 
#define	mav18_stadr	0x000
#define mav18_cmdadr    0x002
#define mav18_datadr	0x010
#define mav18_rdy	0x01
#define mav18_dat_num	18

static int printb(int width, long unsigned dat);



void *
AnalogAsync(void *arg) 
{
	int i, /* i0, j, */ ch[10], ch1, ma_f;
	unsigned type, /* mode, */ base, stat, /* tok, */ flag, delta /*, adr */;
	unsigned char a /*, data_b[60] */;
	unsigned data[20], data1[20];
	long da, da1;
	TaskArg *ta = arg;

	

	if (NULL == ta) return (NULL);

	
	type  = ta->type;
	base  = ta->base;
	ch1   = ta->ch1;
	delta = ta->delta;
	ma_f  = ta->ma_f;

	
	stat=mav18_data(base,data); //check, if card present
	if (stat>=0xFFF) { //something wrong
		if (stat==0xFFF) {
		// printf("\n! Time-out ");
         	   fprintf(stderr, "\nError! Module time-out ");
		   return (NULL);
		} else if (stat==0xFFFF) {
		// printf("\n!    ");
	            fprintf(stderr, "\nError! Module broken or not exist");
		    return (NULL);
		}
	}



	stat=mav18_data(base,data); //input data
	for (i=0; i<mav18_dat_num; i++) data1[i]=data[i]; //remember data
	flag = 1;
	
	
	while (!exit_threads) {
			
                stat=mav18_data(base,data); //input data
                if (stat&0x0008) {
                
				    if (type==2) {
#if 0
					    fprintf (stderr, "\nst=%04X ",stat);
#endif
    					for (i=1; i<=mav18_dat_num; i++) {
	    					da=data[i-1];
		    				da1=(unsigned) data1[i-1];
			    			data1[i-1]=da;
				    		if ((ch1==0)||(i==ch1)){
					    		if ((da>da1+delta)||
						    		(da1>da+delta)) flag=0;
    						}
#if 0
	    					switch (ma_f) {
		    				case 1: { //mA
			    				if (i<=16)
				    			    fprintf (stderr, "% 8.4f",(float)(1280)/65535*da/49.9);
					    		else fprintf (stderr,"% 8.2f",(float)(1280)/65535*(int)da);
						    break;}
    						case 0: { //units
	    						if (i<=16) fprintf (stderr, "% 8ld",da);
		    					else fprintf (stderr, "% 8ld",da);
			    			break;}
				    		default: { //mV
					    		if (i<=16)
						    	fprintf (stderr, "% 8.2f",(float)(1280)/65535*da);
							    else fprintf (stderr, "% 8.2f",(float)(1280)/65535*(int)da);
    						}
	   	    				} //switch (ma_f)
#endif
	    				} //for(i=1;
			    	} else {
				    	a=0x0d;
					    fprintf (stderr, "%cst=%04X ",a,stat);
    					for (i=0; i<4; i++) printb (16,data[ch[i]-1]);
	    			} // if (type==2)

                } else if (stat == 0xFFFF || stat == 0x0FFF) {
			fputs("Module read error\n", stderr);
			return (NULL);
		} else {
#if 0
                    fputc('.',stderr);
#endif
                }

                /*
		if ((stat!=0)&&((stat&0x0008)==0)) flag=0;
                   

                if (flag==0) { //wait for key pressed, if data are broken
                    int ch;
                    fputs("Red flag rised: stat != 0 && stat != 0x0008\n", stderr);
                    return (NULL);
		}
		*/

		delay(20);
	} //while (1)


	return (NULL);
}



/** Analog driver stuff */
unsigned mav18_data( //read mav data. return mav18 status:
//FFFF - -,  18 
//0FFF - - -    50
//0000 -         0000.
//		      .
//		    -     
unsigned port, //mav 18 baseport
unsigned data[]) { //pointer to array[18] of mav data
unsigned i, st;

	//access mav
	inportb(port+2);
	for (i=0; i<0xffff; i++) {
		if (inportb(port+2)&mav18_rdy) break; //if mav accessible
		if (i>50000) {
			inport(port+4);				//end of read
			outportb(port+2,0);
			for (i=0;i<16;data[i++]=0);	//data
			return 0x0fff; //if mav not acessible
		}
	}
	//read status
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	st=inportb(port);		//data
	outportb(port,0xff);
	st=st+(inportb(port)<<8);//data
	inport(port+4);			//end of read

	//reset status
	outportb(port,0x06);    //write enable command
	inportb(port);
	inport(port+4);        //end of commnad

	outportb(port,0x02);    //write command
	inportb(port);
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0x00);
	inportb(port);			//
	outportb(port,0x00);
	inportb(port);			//
	inport(port+4);        //end of commnad

	//read reset status (check it for zero!)
	outportb(port,0x03);
	inportb(port);			//"read" command
	outportb(port,mav18_stadr);
	inportb(port);			//address
	outportb(port,0xff);
	i=inportb(port);		//data
	outportb(port,0xff);
	i|=inportb(port);		//data
	inport(port+4);			//end of read
	if (i) {	//if st!=0
		outportb(port+2,0);
		for (i=0;i<mav18_dat_num;data[i++]=0);	//data
		return 0xffff; 		//if mav absent or fault
	}

	//read data
	outportb(port,0x03);
	inportb(port);			//read command
	outportb(port,mav18_datadr);
	inportb(port);			//address
	for (i=0; i<mav18_dat_num; i++) {
		outportb(port,0xff);
		data[i]=inportb(port);		//low data
		outportb(port,0xff);
		data[i]=data[i]+(inportb(port)<<8);	//data
	}
	inportb(port+4);			//end of read

	outportb(port+2,0);			//free memory

	return st;
}

int printb(int width, long unsigned dat) { //print word binary
char str_dat[49];
int i;

	if (width>48) return -1;

	str_dat[width]=0;
	for (i=width-1; i>=0; i--) {
		if ((dat&0x0001)!=0) str_dat[i]=0x31;
		else str_dat[i]=0x30;
		dat=dat>>1;
	}
	printf(" %s",str_dat);

	return 0;
}

