/******************************************************************************
 * Copyright 2003, 2004, 2005 Alex Karev.
 *
 * This file is part of Modb library.
 *
 * Modb library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * Modb library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Modb library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 ******************************************************************************/
#ifndef _MODB_INC_
#define _MODB_INC_
/* C99 integers types, should be portable, 
 * but as you now, only for gcc :) */
#include <stdint.h> 
#include "rs.h"

#define MODB_RETRIES	8

#define MODB_SEC_TO_WAIT_FOR_RESPONSE	3		/* For version in canonical mode */
#define MODB_ASCII_MAX_PACKET_SIZE		513
#define MODB_RTU_MAX_PACKET_SIZE		256
#define MODB_MAX_REGISTERS_TO_WRITE		123
#define MODB_MAX_REGISTERS_TO_READ		125

#define MODB_FUN_RHR 0x03
#define MODB_FUN_WMR 0x10
#define MODB_FUN_RSI 0x11

#define MODB_START_CHAR ':'
#define MODB_STOP_CHAR1 0x0D
#define MODB_STOP_CHAR2 0x0A

enum {
	MODB_ASCII_MODE,
	MODB_RTU_MODE,
	MODB_MODES_NUMBER
} Modes;

int
modb_test_fun_rhr(Port *p, uint8_t dsta, uint16_t sb, uint16_t w, 
		uint16_t *a, size_t len, unsigned int mode);
int modb_test_fun_wmr(Port *p, uint8_t dsta, uint16_t sb,
		uint16_t *regs, uint16_t w, unsigned int mode);
int modb_test_fun_rsi(Port *p, uint8_t dsta, unsigned int mode);
int modb_slave_simulator(Port *p, uint8_t address, unsigned int mode);
int modb_master_test(Port *p, uint8_t dsta1, uint8_t dsta2, 
                    uint16_t from, uint16_t quantity, unsigned int mode);
int modb_doza_read_test(Port *p, uint8_t dsta, 
                    uint16_t from, uint16_t quantity, unsigned int mode);

#endif

