(* Send a mail.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mail.ml,v 1.1 2003/12/23 16:56:43 uid68240 Exp $
 *
 * To get this working you need to locate registry.cmo and create a caml-bin
 * directory containing mail.cmo. Then set up Apache like this:
 *
 * CamlLoad /the/path/to/registry.cmo
 * Alias /caml-bin/ /path/to/your/caml-bin/
 * <Location /caml-bin>
 *   SetHandler ocaml-bytecode
 *   CamlHandler Registry.handler
 *   Options ExecCGI
 *   Allow from all
 * </Location>
 *
 * Now point your browser at /caml-bin/mail.cmo?subject=Hello to see this
 * script run. Look for errors in the Apache error log.  A mail should be
 * generated and sent to 'root' on the local machine.
 *)

open Apache
open Registry
open Cgi

(* Modify as appropriate. *)
let to_addr = [ "root@localhost" ]

let body =
"This is an email message which was generated by the mod_caml example
script /caml-bin/mail.cmo.  If you got this message unexpectedly then it's
possible one of your users is just experimenting with mod_caml.

To find out more about mod_caml, go to: http://www.merjis.com/developers/

 -- The mail.cmo program"

let run r =
  let q = new cgi r in

  (* 'subject' parameter is required. *)
  try
    let subject = q#param "subject" in

    (* Generate the mail message. *)
    Sendmail.send_mail ~to_addr ~subject ~body ();

    (* Display the confirmation page. *)
    StdPages.ok q "Email message was sent."
  with
      Not_found ->
	StdPages.error q "'subject' parameter for this script is required."

(* Register the script's run function. *)
let () =
  register_script run
