(* Comments system.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: delete_comment.ml,v 1.3 2004/03/02 17:55:10 rwmj Exp $
 *
 * See examples/comments/README
 *)

open Apache
open Cgi
open Comments

let run r (q : cgi) (dbh : Dbi.connection) userid =
  (* Only administrators are permitted to delete comments. *)
  assert (0 < userid && userid < 10);

  let hostname = q#param "hostname" in

  (* Get the comment id. *)
  let id = int_of_string (q#param "id") in

  (* Delete it. *)
  let sth = dbh#prepare_cached "delete from comments where id = ?" in
  sth#execute [`Int id];

  dbh#commit ();

  (* Redirect back to viewing page. *)
  q#redirect ("view_comments.cmo?hostname=" ^ Cgi_escape.escape_url hostname)

let () =
  register_script run
