(* Comments system.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: comments_login.ml,v 1.5 2005/01/05 18:54:43 ChriS Exp $
 *
 * See examples/comments/README
 *)

open Cgi
open Comments

let distant_future = "Sun, 01 Dec 2030 16:00:00 GMT"

let run r (q : cgi) dbh _ =
  (* Get parameters. *)
  let id = int_of_string (q#param "id") in
  let name = string_trim (q#param "name") in
  let password = q#param "password" in

  (* Get the URI for redirection. *)
  let sth = dbh#prepare_cached "select uri from comments_pages where id = ?" in
  sth#execute [`Int id];

  let uri = sth#fetch1string () in

  (* Check username and password. *)
  let sth = dbh#prepare_cached "select id from comments_users
                                 where name = ? and password = ?" in
  sth#execute [`String name; `String password];

  try
    let userid = sth#fetch1int () in

    (* Username and password combination is OK. Create a session cookie. *)
    let sessionid = random_sessionid () in

    let sth =
      dbh#prepare_cached "delete from comments_sessions where userid = ?" in
    sth#execute [`Int userid];

    let sth = dbh#prepare_cached "insert into comments_sessions
                                  (userid, sessionid) values (?, ?)" in
    sth#execute [`Int userid; `String sessionid];

    dbh#commit ();

    let cookie = Cookie.cookie "comments_auth" sessionid
		   ~expires:distant_future ~path:"/caml-bin" in

    (* Redirect back to original page, with cookie. *)
    q#redirect ~cookie uri
  with
      Not_found ->
	Template.StdPages.error q "Name or password incorrect."

let () =
  register_script run
