(* Example script with cookies.
 * Copyright (C) 2003 Merjis Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cookies.ml,v 1.4 2004/12/11 21:51:30 ChriS Exp $
 *
 * To get this working you need to locate registry.cmo and create a caml-bin
 * directory containing cookies.cmo. Then set up Apache like this:
 *
 * CamlLoad /the/path/to/registry.cmo
 * Alias /caml-bin/ /path/to/your/caml-bin/
 * <Location /caml-bin>
 *   SetHandler ocaml-bytecode
 *   CamlHandler Registry.handler
 *   Options ExecCGI
 *   Allow from all
 * </Location>
 *
 * Now point your browser at /caml-bin/cookies.cmo to see this
 * script run. Look for errors in the Apache error log.
 *)

open Apache
open Registry
open Cgi

(* This is the template. Normally, of course, the template should be placed in
 * an external file so that there is a clean separation of code from
 * presentation. But in this instance we include it directly in the script
 * for simplicity of installation.
 *)
let template = "
<html>
 <head><title>::title_html::</title></head>
  <body bgcolor=\"#ffffff\">
  <h1>::title_html::</h1>
  <p>
    The following cookies were supplied by the browser:
  </p>
  <table border=\"1\"><tr><th>Name</th><th>Value</th></tr>
   ::table(cookies)::
   <tr><td>::name_html::</td><td>::value_html::</td></tr>
   ::end::
  </table>
  <h2>Set a cookie in the browser</h2>
  <form method=\"post\" action=\"cookies.cmo\">
   Name: <input name=\"name\" value=\"CookieName\">
   Value: <input name=\"value\" value=\"Value of the cookie\">
   <input type=\"submit\" name=\"setcookie\" value=\"Send\">
  </form>
 </body>
</html>"

(* The template is compiled once when the script is loaded. *)
let template = Template.template_from_string template;;
template#set "title" "Cookies demonstration CGI script"

let run r =
  let q = new cgi r in

  (* Set a cookie? *)
  if q#param_true "setcookie" then (
    let name = q#param "name" in
    let value = q#param "value" in
    let cookie = Cookie.cookie name value in
    q#redirect ~cookie (q#url ())
  ) else (
    (* Find out what cookies were sent with the request. Returns a list
     * of cookie objects. For each cookie object, you can retrieve the
     * name and value using cookie#name or cookie#value.
     *
     * You can also call q#cookie name to retrieve a particular cookie
     * object by name.
     *)
    let cookies = q#cookies in

    (* Assemble the table. *)
    let table =
      List.map
	(fun cookie ->
	   [ "name", Template.VarString cookie#name;
	     "value", Template.VarString cookie#value ])
	cookies in

    template#table "cookies" table;

    (* Display the page. *)
    q#template template
  )

(* Register the script's run function. *)
let () =
  register_script run
