(* [split_query "SELECT name FROM foo WHERE id = ? AND bar = ?"]
   returns the splitted list in reverse order [""; " AND bar = ";
   "SELECT name FROM foo WHERE id = "]. *)
let split_query query =
  let n = String.length query in
  let rec outside_quote l i0 i =
    if i >= n then (String.sub query i0 (i - i0)) :: l
    else match String.unsafe_get query i with
    | '?' -> outside_quote ((String.sub query i0 (i - i0)) :: l) (i+1) (i+1)
    | '\'' -> inside_quote l i0 (i+1)
    | _ -> outside_quote l i0 (i+1)
  and inside_quote l i0 i =
    if i >= n then failwith "Incorrect query syntax" (* FIXME: -> Dbi.Error *)
    else if String.unsafe_get query i = '\'' then
      let i1 = i + 1 in
      if i1 >= n || String.unsafe_get query i1 <> '\'' then
        outside_quote l i0 i1
      else (* c.[i1] = '\'' *)
        inside_quote l i0 (i1 + 1)
    else
      inside_quote l i0 (i + 1)  in
  outside_quote [] 0 0

(* Given the splitted query [split_query], the arguments [args] and
   an encoding function [sql2db], [make_query sql2db split_query args]
   returns a string containing the query where the placeholders in the
   original query (before it got splitted) are substitued with the
   corresponding arguments. *)
let make_query msg sql2db q_rev (args: Dbi.sql_t list) =
  let rec loop acc q a =
    match q, a with
    | q0 :: qtl, a0 :: atl -> loop ((sql2db a0) ^ q0 ^ acc) qtl atl
    | [q0], [] -> q0 ^ acc
    | _ -> invalid_arg msg in
  loop "" q_rev (List.rev args)
